var file_names = {
};

// ======================
// util per lo ZIP
// ======================
function sanitizeName(s) {
    return (s || "").toString().trim().replace(/\s+/g, "_").replace(/[^\w.\-]/g, "");
}
async function fetchBlob(url) {
    try {
        const res = await fetch(url, { credentials: "same-origin" });
        if (!res.ok) throw new Error("HTTP " + res.status);
        return await res.blob();
    } catch (e) {
        console.warn("Impossibile scaricare:", url, e);
        return null;
    }
}

// ======================
// CLICK PRINCIPALE
// ======================
$(document).on("click", ".crea-files", async function () {
    const codice = $(`#cuaa_beneficiario`).val();
    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val();
    var errori_totali = 0;
    var errori_sezione_anagrafica = check_sezione_anagrafica();
    var errori_sezione_iniziativa = check_sezione_iniziativa();
    var errori_sezione_richiesta_contributo = check_sezione_richiesta_contributo();
    var errori_dati_bancari = check_sezione_dati_bancari();
    var errori_sezione_rendicontazione_spese = check_sezione_rendicontazione_spese();
    var errori_allegati = check_sezione_allegati();
    var errori_sezione_privacy = check_sezione_privacy();
    var errori_firma = check_errori_firma();
    var errori_ulteriori_dichiarazioni = check_sezione_ulteriori_dichiarazioni();
    var errori_allegati_tabella = check_allegati_tabella();

    if (tipo_richiesta === "impegno") {
        errori_totali = errori_sezione_anagrafica * 1 + errori_sezione_iniziativa * 1 + errori_sezione_richiesta_contributo * 1 + errori_allegati * 1 + errori_sezione_privacy * 1 + errori_firma * 1 + errori_ulteriori_dichiarazioni * 1;
    } else {
        errori_totali = errori_sezione_anagrafica * 1 + errori_sezione_iniziativa * 1 + errori_dati_bancari * 1 + errori_sezione_rendicontazione_spese * 1 + errori_allegati * 1 + errori_allegati_tabella * 1 + errori_sezione_privacy * 1 + errori_firma * 1 + errori_ulteriori_dichiarazioni * 1;
    }

    if (errori_totali == 0) {
        // Inizializza gli array come fai già (li lascio invariati)
        file_names.delibera_affidamento = [];
        file_names.delibera_pagamento = [];
        file_names.mandato_pagamento = [];
        file_names.fattura = [];
        file_names.ricevuta_bonifico_assegno = [];
        file_names.prospetto_riparto = [];
        file_names.allegato_progetto = [];
        file_names.allegato_progetto2 = [];   // 👈 AGGIUNTA
        file_names.allegato_piano_economico = [];
        file_names.allegato_documento_identita = [];
        file_names.allegato_gastronomia = [];
        file_names.allegato_autocertificazione = [];
        file_names.allegato_statuto = [];
        file_names.allegato_antimafia = [];
        file_names.allegato_curricula = [];
        file_names.allegato_DURC = [];
        file_names.allegato_relazione = [];
        file_names.allegato_documentazione_pubblicitaria = [];
        file_names.allegato_dichiarazione_no_contributi = [];
        file_names.allegato_scostamenti = [];
        file_names.allegato_foto = [];
        file_names.allegato_link_video = [];
        file_names.allegato_delega_sindaco = [];
        // NOVITÀ: crea ZIP unico con tutto dentro
        await crea_zip(codice);
        //download_file_privacy(codice);

    }
    else {
        const $firstErrorSection = $('.background-color-error-accordion:visible:first');
        if ($firstErrorSection.length) {
            $('html, body').animate({
                scrollTop: $firstErrorSection.offset().top - 125
            }, 500);
        }
        return;
    }

});

// ======================
// ZIP orchestrator
// ======================
async function crea_zip(codice) {
    if (typeof JSZip === "undefined") {
        alert("JSZip non è caricato. Includilo prima di usare questa funzione.");
        return;
    }
    const versioneRaw = $("#versione").val() || "1_0";
    const versione = versioneRaw.replace(".", "_");

    const zip = new JSZip();
    const rootFolderName = `${sanitizeName(codice)}_${versione}`;
    const root = zip.folder(rootFolderName);
    const foldPDF = root; // pdf in root
    const foldAllegatiVari = root.folder("Allegati_Vari");
    const foldAllegatiTabella = root.folder("Allegati_Tabella");
    // *** RIMOSSA LA CARTELLA "Excel" ***

    // 1) Intercetto jsPDF.save per catturare il PDF del modulo nello ZIP (senza download separato)
    const JsPdfClass = (window.jspdf && window.jspdf.jsPDF) || window.jsPDF || null;
    let originalJsPdfSave = null;
    if (JsPdfClass) {
        const proto = JsPdfClass.API || JsPdfClass.prototype;
        if (proto && proto.save) {
            originalJsPdfSave = proto.save;
            proto.save = function (filename) {
                try {
                    const blob = this.output("blob");
                    foldPDF.file(filename, blob);
                } catch (e) {
                    console.warn("Impossibile catturare il PDF in ZIP:", e);
                }
                // Non eseguire il download separato
                // return originalJsPdfSave.apply(this, arguments);
            };
        }
    }

    // 2) Intercetto temporaneamente window.saveAs per catturare TUTTI i file salvati da download_* e da eventuale crea_dati_excel()
    const oldSaveAs = window.saveAs;
    let currentFolderForSaveAs = foldAllegatiVari; // default

    window.saveAs = function (fileOrBlob, maybeName) {
        try {
            // Normalizza a Blob
            let blob;
            if (fileOrBlob instanceof Blob) {
                blob = fileOrBlob;
            } else {
                blob = new Blob([fileOrBlob], {
                    type: (fileOrBlob && fileOrBlob.type) || "application/octet-stream"
                });
            }

            // ⚠️ PRIORITÀ al nome passato (maybeName)
            const fileName =
                (typeof maybeName === "string" && maybeName.trim().length > 0)
                    ? maybeName
                    : (fileOrBlob && fileOrBlob.name) || "file.bin";

            (currentFolderForSaveAs || root).file(fileName, blob);

            // opzionale: log per controllare
            console.log("📥 Aggiunto allo ZIP:", fileName,
                "→ cartella:", (currentFolderForSaveAs || root).name || "(root)");
        } catch (e) {
            console.warn("saveAs intercettato ma non aggiunto allo ZIP:", e);
        }
        // nessun download diretto
    };
    try {
        // 2a) Genera e "salva" il PDF (finirà nello ZIP tramite l'override di jsPDF.save)
        // window.__currentZipFolder = foldPDF;
        //  crea_file_pdf(codice);
        // window.__currentZipFolder = null;


        // 2b) Allegati VARI
        currentFolderForSaveAs = foldAllegatiVari;
        download_allegati_vari(codice);

        // 2c) Allegati TABELLA
        currentFolderForSaveAs = foldAllegatiTabella;
        download_allegati_tabella(codice);

        // 2d) Excel -> metti direttamente nel root dello ZIP (niente cartella Excel)
        // 2d) Excel -> lo genero e lo metto nel root dello ZIP
        currentFolderForSaveAs = root;
        if (typeof crea_dati_excel === "function") {
            try {
                const excelResult = await crea_dati_excel();
                if (excelResult && excelResult.blob) {
                    root.file(excelResult.nomeFile, excelResult.blob);
                }
            } catch (e) {
                console.warn("crea_dati_excel errore:", e);
            }
        }

        // 2e) Privacy dal link (se possibile) -> aggiungi allo ZIP
        const a = document.getElementById('pdf_privacy_policy');
        if (a && a.href) {
            const blob = await fetchBlob(a.href);
            if (blob) {
                const nomePrivacy = `${sanitizeName(codice)}_Privacy_Policy_${versione}.pdf`;
                root.file(nomePrivacy, blob);
            }
        }


        // Ora che file_names è popolato coi nomi reali, genera il PDF e mettilo nello ZIP
        window.__currentZipFolder = foldPDF;
        crea_file_pdf(codice, file_names);   // <— PASSO file_names
        window.__currentZipFolder = null;
    } finally {
        // ripristina le funzioni originali
        if (originalJsPdfSave) {
            const proto = JsPdfClass.API || JsPdfClass.prototype;
            if (proto) proto.save = originalJsPdfSave;
        }
        window.saveAs = oldSaveAs;
    }

    // 3) genera lo ZIP e scarica
    const zipBlob = await zip.generateAsync({ type: "blob" });

    // leggo il tipo di richiesta dal radio
    const tipoRichiesta = $('input[name=tipo_richiesta]:checked').val();

    // mappatura:
    // - "impegno"        -> "Richiesta"
    // - "liquidazione"   -> "Rendicontazione"
    let labelTipo;
    if (tipoRichiesta === 'liquidazione') {
        labelTipo = 'Rendicontazione';
    } else {
        // default: impegno
        labelTipo = 'Richiesta';
    }

    saveAs(zipBlob, `${sanitizeName(codice)}_${labelTipo}_${versione}.zip`);
}

// ======================
// TUTTO IL TUO CODICE SOTTO resta invariato
// ======================

function check_errors(fields, error_class, regex, error_regex_message, error_message) {
    var errors = 0;
    fields.each(function () {
        valida_campo($(this), error_class, regex, error_regex_message, error_message);
        if ($(this).next(error_class).hasClass("invalid-feedback")) {
            errors++;
        }
    });
    return errors;
}

function check_error(field, error_class, validation_func, isValue) {
    var error = 0;
    var value = isValue ? field.val() : field;
    validation_func(value);
    if (field.next(error_class).hasClass("invalid-feedback")) {
        error++;
    }
    return error;
}

function check_errori_firma() {
    var errori_firma = 0;
    var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
    var luogoFirma = $("#luogo_per_firma").val();
    if (luogoFirma.length == 0) {
        $("#luogo_per_firma").addClass("is-invalid");
        $("#errore_luogo_per_firma").addClass("invalid-feedback d-block");
        $("#errore_luogo_per_firma").text("Luogo obbligatorio.");
        errori_firma++;
    }
    else if (!reg_luogo_nascita_residenza.test(luogoFirma)) {
        $("#luogo_per_firma").addClass("is-invalid");
        $("#errore_luogo_per_firma").addClass("invalid-feedback d-block");
        $("#errore_luogo_per_firma").text("Luogo non valido.");
        errori_firma++;
    }
    else {
        $("#luogo_per_firma").removeClass("is-invalid");
        $("#errore_luogo_per_firma").removeClass("invalid-feedback");
        $("#errore_luogo_per_firma").text("");
    }

    var dataFirma = $("#data_per_firma").val();
    const array_data = dataFirma.split("-");
    var anno = array_data[0];
    if (dataFirma == "") {
        $("#data_per_firma").addClass("is-invalid");
        $("#errore_data_per_firma").addClass("invalid-feedback d-block");
        $("#errore_data_per_firma").text("Data firma obbligatoria.");
        errori_firma++;
    }
    else if (anno < 1900 || anno > 2026) {
        $("#data_per_firma").addClass("is-invalid");
        $("#errore_data_per_firma").addClass("invalid-feedback d-block");
        $("#errore_data_per_firma").text("Data firma non valida.");
        errori_firma++;
    }
    else {
        $("#data_per_firma").removeClass("is-invalid");
        $("#errore_data_per_firma").removeClass("invalid-feedback");
        $("#errore_data_per_firma").text("");
    }
    return errori_firma;
}
function check_sezione_anagrafica() {
    const ok = typeof validaSezioneAnagrafica === 'function' ? validaSezioneAnagrafica() : true;
    return ok ? 0 : 1;
}

function valida_finestra_pec() {
    const linea = $("#selezione_tipo_linea").val();
    const dataInizioVal = $("#data_inizio").val();
    const dataFirmaVal = $("#data_per_firma").val(); // data presentazione istanza

    // Se manca qualcosa, NON blocchiamo qui: ci pensano gli altri "obbligatorio"
    if (!linea || !dataInizioVal || !dataFirmaVal) return true;

    const df = new Date(dataFirmaVal);
    const today = new Date();

    // normalizzo a mezzanotte per confrontare solo la data
    df.setHours(0, 0, 0, 0);
    today.setHours(0, 0, 0, 0);

    // 1) giorno firma NON può essere oltre il 28 (vale per tutti i mesi)
    if (df.getDate() > 28) {
        return false; // KO
    }

    // 2) finestra: da oggi a 28 dicembre di QUESTO anno
    const yearNow = today.getFullYear();
    const endLimit = new Date(yearNow, 11, 28); // 11 = dicembre
    endLimit.setHours(0, 0, 0, 0);

    // df deve stare tra oggi e 28/12 anno corrente
    return df >= today && df <= endLimit;
}


function check_sezione_iniziativa() {
    let errori_iniziativa = 0;

    // validatori singoli
    valida_titolo($('#titolo_iniziativa').val(), '');
    if ($('#errore_titolo_iniziativa').hasClass('invalid-feedback')) errori_iniziativa++;

    valida_data($('#data_inizio').val(), 'inizio');
    if ($('#errore_data_inizio').hasClass('invalid-feedback')) errori_iniziativa++;

    valida_data($('#data_fine').val(), 'fine');
    if ($('#errore_data_fine').hasClass('invalid-feedback')) errori_iniziativa++;

    valida_provincia_iniziativa($('#sede_provincia_iniziativa').val(), '');
    if ($('#errore_sede_provincia_iniziativa').hasClass('invalid-feedback')) errori_iniziativa++;

    valida_luogo_iniziativa($('#sede_iniziativa').val(), '');
    if ($('#errore_sede_iniziativa').hasClass('invalid-feedback')) errori_iniziativa++;

    valida_descrizione($('#descrizione_iniziativa').val(), '');
    if ($('#errore_descrizione_iniziativa').hasClass('invalid-feedback')) errori_iniziativa++;

    if (!$('#allegato_progetto')[0]?.files?.length) {
        $('#allegato_progetto').addClass('is-invalid');
        $('#errore_allegato_progetto').addClass('invalid-feedback').text('Allegato obbligatorio.');
        errori_iniziativa++;
    } else {
        $('#allegato_progetto').removeClass('is-invalid').addClass('is-valid');
        $('#errore_allegato_progetto').removeClass('invalid-feedback').text('');
    }
    // 🔴 controllo finestra PEC sulla data_per_firma
    const finestraOK = valida_finestra_pec();
    const $alertErr = $("#alert_data_inizio_error");

    if (!finestraOK) {
        errori_iniziativa++;

        $alertErr
            .removeClass("d-none")
            .addClass("alert", "alert-danger")
            .text("La data di presentazione dell’istanza è fuori dalla finestra temporale prevista dal bando");
    } else {
        $alertErr.addClass("d-none").text("");
    }


    // usa paintHeader uniforme
    paintHeader('#iniziativa', 'validazione_sezione_iniziativa', errori_iniziativa);

    return errori_iniziativa;
}
// Quando cambio linea, data inizio o data firma, ricontrollo subito la finestra PEC
$(document).on('change', '#selezione_tipo_linea, #data_inizio, #data_per_firma', function () {
    const finestraOK = valida_finestra_pec();
    const $alertErr = $("#alert_data_inizio_error");

    if (finestraOK) {
        // tutto ok → nascondo il messaggio rosso
        $alertErr
            .addClass("d-none")
            .removeClass("alert alert-danger")
            .text("");
    } else {
        // ancora fuori finestra → lo mostro (se vuoi)
        $alertErr
            .removeClass("d-none")
            .addClass("alert alert-danger")
            .text("La data di presentazione dell’istanza è fuori dalla finestra temporale prevista dal bando");
    }
});


function check_sezione_richiesta_contributo() {
    // Autofill contributo se è stata scelta la linea ma l'importo è vuoto
    const linea = ($('#selezione_tipo_linea').val() || '').trim();
    const $importo = $('#contributo_ammesso');
    if (linea && !$importo.val().trim()) {
        riempi_contributo_richiesto(linea);
    }

    // Usa la validazione della sezione già definita da te
    const ok = validaSezioneContributo();

    // In crea_files sommi i numeri: 0 = nessun errore, 1 = sezione KO
    return ok ? 0 : 1;
}
function check_sezione_dati_bancari() {
    // true se è stata selezionata la rendicontazione (liquidazione)
    var isLiquidazione = $('input[name="tipo_richiesta"][value="liquidazione"]').is(':checked');

    const headerBtn = document.querySelector('#dati_bancari .accordion-button');
    const badgeSpan = document.getElementById('validazione_sezione_dati_bancari');

    // Se NON è rendicontazione, la sezione Dati Bancari NON è obbligatoria
    // → header neutro, nessun errore
    if (!isLiquidazione) {
        if (headerBtn && badgeSpan) {
            headerBtn.classList.remove(
                'bg-danger', 'bg-success', 'text-white',
                'background-color-error-accordion',
                'background-color-success-accordion'
            );
            badgeSpan.className = '';
            badgeSpan.textContent = '';
        }
        return 0; // nessun errore
    }

    // Se è rendicontazione, eseguo la validazione vera
    if (typeof window.validateSezioneDatiBancari === 'function') {
        var errori = window.validateSezioneDatiBancari(); // qui SI aggiorna l’header
        return errori; // 0 = ok, >0 = errori
    }

    // se per qualche motivo lo script di validazione non è stato caricato
    return 0;
}
function check_sezione_rendicontazione_spese() {
    console.group("🔍 Check Sezione Rendicontazione Spese");

    // ================
    //  REGEX LOCALI
    // ================
    const REGEX_STRING = /^.{2,}$/;
    const REGEX_DATA = /^\d{4}\-(0[1-9]|1[0-2])\-(0[1-9]|[12][0-9]|3[01])$/;
    const REGEX_MONEY_DOT = /^\d+(\.\d{1,2})?$/;

    // mappa allegati locale (vale solo in questa funzione)
    const VALIDAZIONI_ALLEGATI_LOCAL = {
        comuni: {
            delibera_affidamento: {
                msg: "Delibera di affidamento obbligatoria.",
                errore: ".errore_delibera_affidamento"
            },
            delibera_pagamento: {
                msg: "Delibera di pagamento obbligatoria.",
                errore: ".errore_delibera_pagamento"
            },
            mandato_pagamento: {
                msg: "Mandato di pagamento obbligatorio.",
                errore: ".errore_mandato_pagamento"
            },
            fattura: {
                msg: "Documento fattura/titolo obbligatorio.",
                errore: ".errore_fattura"
            }
        },
        associazioni: {
            fattura: {
                msg: "Documento fattura/titolo obbligatorio.",
                errore: ".errore_fattura"
            },
            ricevuta_bonifico_assegno: {
                msg: "Ricevuta di bonifico/assegno obbligatoria.",
                errore: ".errore_ricevuta_bonifico_assegno"
            }
        },
        opt: {
            prospetto_riparto: {
                msg: "Prospetto di riparto obbligatorio.",
                errore: ".errore_prospetto_riporto"
            }
        }
    };

    // legge il tipo beneficiario dai radio (comuni | associazioni)
    function getTipoBeneficiarioLocal() {
        return $('input[name=tipo_beneficiario]:checked').val() || '';
    }

    let totalErrors = 0;
    let $firstInvalid = null;

    const $sezione = $('#liquidazione_spese');

    // ==========================
    // 1) PULIZIA STATO SEZIONE
    // ==========================
    $sezione.find('input').removeClass('is-valid is-invalid');
    $sezione.find(
        '.errore_oggetto_spesa, .errore_data_spesa, .errore_beneficiario_spesa, ' +
        '.errore_cuaa_spesa, .errore_importo_spesa, .errore_n_fattura_spesa, ' +
        '.errore_delibera_affidamento, .errore_delibera_pagamento, .errore_mandato_pagamento, ' +
        '.errore_fattura, .errore_ricevuta_bonifico_assegno, .errore_prospetto_riporto, ' +
        '#errore_numeroDRS, #errore_dataDRS, #errore_importoAmmissibile'
    ).removeClass('invalid-feedback').html('');

    $sezione.find('tr.riga-errore').removeClass('riga-errore');

    const $alertDRS = $('#alert_importo_drs').addClass('d-none').text('');

    // helper locale per segnare errore su un campo
    function markError($input, $errBox, msg) {
        $input.addClass('is-invalid');
        if ($errBox && $errBox.length) {
            $errBox.addClass('invalid-feedback')
                .html(`<small class="text-danger">${msg}</small>`);
        }
        totalErrors++;
        if (!$firstInvalid) $firstInvalid = $input;
    }

    // ==========================
    // 2) RIGHE TABELLA INVESTIMENTI
    // ==========================
    $('#investimenti tbody tr[id^="oggetto_spesa_"]').each(function () {
        const $riga = $(this);
        let rowErr = 0;

        const $oggetto = $riga.find('input[name=oggetto_spesa]');
        const $data = $riga.find('input[name=data_spesa]');
        const $ben = $riga.find('input[name=beneficiario_spesa]');
        const $cuaa = $riga.find('input[name=cuaa_spesa]');
        const $imp = $riga.find('input[name=importo_spesa]');
        const $fatt = $riga.find('input[name=n_fattura_spesa]');

        // Oggetto
        const valOggetto = ($oggetto.val() || '').trim();
        const $errOggetto = $oggetto.siblings('.errore_oggetto_spesa');
        if (!valOggetto) {
            markError($oggetto, $errOggetto, "Oggetto della spesa obbligatorio.");
            rowErr++;
        } else if (!REGEX_STRING.test(valOggetto)) {
            markError($oggetto, $errOggetto, "Minimo 2 caratteri.");
            rowErr++;
        }

        // Data
        const valData = ($data.val() || '').trim();
        const $errData = $data.siblings('.errore_data_spesa');
        if (!valData) {
            markError($data, $errData, "Data della spesa obbligatoria.");
            rowErr++;
        } else if (!REGEX_DATA.test(valData)) {
            markError($data, $errData, "Data non valida (AAAA-MM-GG).");
            rowErr++;
        }

        // Beneficiario
        const valBen = ($ben.val() || '').trim();
        const $errBen = $ben.siblings('.errore_beneficiario_spesa');
        if (!valBen) {
            markError($ben, $errBen, "Beneficiario della spesa obbligatorio.");
            rowErr++;
        } else if (!REGEX_STRING.test(valBen)) {
            markError($ben, $errBen, "Minimo 2 caratteri.");
            rowErr++;
        }

        // CUAA
        let valCuaa = ($cuaa.val() || '').trim().toUpperCase().replace(/[^A-Z0-9]/g, '');
        $cuaa.val(valCuaa);
        const $errCuaa = $cuaa.siblings('.errore_cuaa_spesa');
        if (!valCuaa) {
            markError($cuaa, $errCuaa, "Codice CUAA obbligatorio.");
            rowErr++;
        }
        // se hai la funzione controllaCFPIVA, puoi togliere questo commento:
        // else if (typeof controllaCFPIVA === 'function' && !controllaCFPIVA(valCuaa)) {
        //   markError($cuaa, $errCuaa, "Codice CUAA errato.");
        //   rowErr++;
        // }

        // Importo
        const valImp = ($imp.val() || '').trim();
        const $errImp = $imp.siblings('.errore_importo_spesa');
        if (!valImp) {
            markError($imp, $errImp, "Inserisci l'importo.");
            rowErr++;
        } else if (valImp.includes(',') || !REGEX_MONEY_DOT.test(valImp)) {
            markError($imp, $errImp, "Importo non valido. Usa il punto: 1234.56.");
            rowErr++;
        }

        // Fattura/Titolo
        const valFatt = ($fatt.val() || '').trim();
        const $errFatt = $fatt.siblings('.errore_n_fattura_spesa');
        if (!valFatt) {
            markError($fatt, $errFatt, "Identificativo della fattura o del titolo obbligatorio.");
            rowErr++;
        } else if (!REGEX_STRING.test(valFatt)) {
            markError($fatt, $errFatt, "Minimo 2 caratteri.");
            rowErr++;
        }

        if (rowErr > 0) {
            $riga.addClass('riga-errore');
        } else {
            $riga.removeClass('riga-errore');
        }
    });

    // ==========================
    // 3) ALLEGATI
    // ==========================
    const tipo = getTipoBeneficiarioLocal();
    const cfgTipo = VALIDAZIONI_ALLEGATI_LOCAL[tipo] || {};

    Object.keys(cfgTipo).forEach(name => {
        const cfg = cfgTipo[name];
        $('#allegati_investimenti tbody input[name=' + name + ']').each(function () {
            const $input = $(this);
            const $err = $input.siblings(cfg.errore);
            const file = $input[0].files[0];

            if (!file) {
                markError($input, $err, cfg.msg);
            } else {
                $input.removeClass('is-invalid').addClass('is-valid');
                $err.removeClass('invalid-feedback').html('');
            }
        });
    });

    // opzionale: prospetto riparto
    const cfgOpt = VALIDAZIONI_ALLEGATI_LOCAL.opt || {};
    if (cfgOpt.prospetto_riparto) {
        $('#allegati_investimenti tbody input[name=prospetto_riparto]').each(function () {
            const $input = $(this);
            const $err = $input.siblings(cfgOpt.prospetto_riparto.errore);
            const file = $input[0].files[0];

            if (!file) {
                markError($input, $err, cfgOpt.prospetto_riparto.msg);
            } else {
                $input.removeClass('is-invalid').addClass('is-valid');
                $err.removeClass('invalid-feedback').html('');
            }
        });
    }

    // ==========================
    // 4) DRS (numero, data, importo)
    // ==========================
    const $numDRS = $('#numeroDRS');
    const $dataDRS = $('#dataDRS');
    const $impDRS = $('#importoAmmissibile');

    const $errNum = $('#errore_numeroDRS');
    const $errData = $('#errore_dataDRS');
    const $errImpD = $('#errore_importoAmmissibile');

    const numVal = ($numDRS.val() || '').trim();
    if (!numVal) {
        markError($numDRS, $errNum, "Numero DRS obbligatorio.");
    }

    const dataVal = ($dataDRS.val() || '').trim();
    if (!dataVal) {
        markError($dataDRS, $errData, "Data del DRS obbligatoria.");
    }

    let impDRSVal = ($impDRS.val() || '').toString().trim().replace(',', '.');
    if (!impDRSVal) {
        markError($impDRS, $errImpD, "Importo DRS obbligatorio.");
    } else if (!REGEX_MONEY_DOT.test(impDRSVal)) {
        markError($impDRS, $errImpD, "Importo non valido. Usa il punto: 1234.56.");
    }

    // ==========================
    // 5) Controllo importo DRS vs totale spese
    // ==========================
    const importoDRS = parseFloat(impDRSVal || '0');
    const totStrRaw = ($('#importo_totale').attr('valore') || $('#importo_totale').text() || '0').toString();
    const importoTotale = parseFloat(totStrRaw.replace(',', '.'));

    if (!isNaN(importoDRS) && !isNaN(importoTotale) && importoDRS <= importoTotale) {
        $alertDRS
            .removeClass('d-none')
            .text(
                `Attenzione: l'importo totale (${importoTotale.toFixed(2)} €)` +
                `non può superare il valore del decreto (${importoDRS.toFixed(2)} €).`
            );
        totalErrors++;
    }

    // ==========================
    // 6) COLORA HEADER ACCORDION
    // ==========================
    const headerBtn = document.querySelector('#liquidazione_spese .accordion-button');
    const badgeSpan = document.getElementById('validazione_sezione_liquidazione_spese');

    if (headerBtn && badgeSpan) {
        headerBtn.classList.remove(
            'bg-danger', 'bg-success', 'text-white',
            'background-color-success-accordion', 'background-color-error-accordion'
        );
        badgeSpan.classList.remove('badge', 'text-bg-success', 'text-bg-error');
        badgeSpan.classList.add('badge');

        if (totalErrors > 0) {
            headerBtn.classList.add('background-color-error-accordion', 'text-white');
            badgeSpan.classList.add('text-bg-error');
            badgeSpan.textContent =
                `Vi ${totalErrors === 1 ? 'è' : 'sono'} ${totalErrors} ${totalErrors === 1 ? 'errore' : 'errori'}`;
        } else {
            headerBtn.classList.add('background-color-success-accordion', 'text-white');
            badgeSpan.classList.add('text-bg-success');
            badgeSpan.textContent = 'Sezione Compilata Correttamente';
        }
    }

    // ==========================
    // 7) SCROLL AL PRIMO ERRORE
    // ==========================
    if ($firstInvalid && $firstInvalid.length) {
        $('html, body').animate({ scrollTop: $firstInvalid.offset().top - 120 }, 350);
        $firstInvalid.trigger('focus');
    }

    console.log("Totale errori Rendicontazione Spese:", totalErrors);
    console.groupEnd();

    return totalErrors; // 0 = ok, >0 = blocca
}
function check_sezione_allegati() {
    let errori_allegati = 0;

    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val(); // "impegno" | "liquidazione"
    const sectionSelector = '#allegati_' + tipo_richiesta;
    const $section = $(sectionSelector);

    // 1) Se esiste il validatore modulare per "impegno", usalo
    if (window.ValidationAllegati && typeof window.ValidationAllegati.validate === 'function' && tipo_richiesta === 'impegno') {
        window.ValidationAllegati.validate();
    }

    // 2) Conteggio errori + marcatura campi (solo file obbligatori visibili e attivi)
    const tipo_beneficiario = $('input[name=tipo_beneficiario]:checked').val();

    const $inputsDaValidare = $section
        .find('input[required][type="file"]')       // solo file
        .filter(function () {
            const $inp = $(this);
            if ($inp.is(':disabled')) return false;   // salta disabilitati
            if (!$inp.is(':visible')) return false;   // salta nascosti (display:none)
            // salta se ha un ancestor nascosto (es. accordion chiuso con .d-none)
            if ($inp.closest('.d-none, [hidden]').length) return false;

            // opzionale: se usi attributi data- per scopo/beneficiario
            const forBen = $inp.data('beneficiario');           // 'comuni' | 'associazioni'
            if (forBen && forBen !== tipo_beneficiario) return false;

            const forTipo = $inp.data('tipo');                  // 'impegno' | 'liquidazione'
            if (forTipo && forTipo !== tipo_richiesta) return false;

            return true;
        });

    $inputsDaValidare.each(function () {
        const $inp = $(this);
        const $err = $(`#errore_${this.id}`);

        const hasValue = this.files && this.files.length > 0;

        if (!hasValue) {
            errori_allegati++;
            $inp.addClass('is-invalid').removeClass('is-valid');
            if ($err.length) {
                $err.addClass('invalid-feedback')
                    .html('<small class="text-danger">Campo obbligatorio.</small>');
            }
        } else {
            $inp.removeClass('is-invalid').addClass('is-valid');
            if ($err.length) $err.removeClass('invalid-feedback').text('');
        }
    });

    // 3) Aggiorna badge + header
    const string_errori = errori_allegati === 1 ? ' errore' : ' errori';
    const string_verbo = errori_allegati === 1 ? ' è ' : ' sono ';

    $(`${sectionSelector} .accordion-header button`)
        .removeClass('background-color-success-accordion background-color-error-accordion');
    $(`#validazione_sezione_allegati_${tipo_richiesta}`)
        .removeClass('badge text-bg-error text-bg-success');

    if (errori_allegati === 0) {
        $(`#validazione_sezione_allegati_${tipo_richiesta}`)
            .text('Sezione Compilata Correttamente')
            .addClass('badge text-bg-success');
        $(`${sectionSelector} .accordion-header button`)
            .addClass('background-color-success-accordion');
    } else {
        $(`#validazione_sezione_allegati_${tipo_richiesta}`)
            .text('Vi ' + string_verbo + errori_allegati + string_errori)
            .addClass('badge text-bg-error');
        $(`${sectionSelector} .accordion-header button`)
            .addClass('background-color-error-accordion');
    }

    return errori_allegati;
}
// --- VALIDAZIONE LINK VIDEO ---
function valida_link_video() {
    const $input = $('#allegato_link_video');
    const $err = $('#errore_allegato_link_video');
    let link = ($input.val() || '').trim();

    // Dominio (anche senza schema), www opzionale, TLD 2–63, IP o localhost, porta opzionale, path/query/hash
    const REGEX_URL =
        /^(?:(?:https?:)?\/\/)?(?:localhost|\d{1,3}(?:\.\d{1,3}){3}|(?:[a-z0-9](?:[a-z0-9-]{0,61}[a-z0-9])?\.)+[a-z]{2,63})(?::\d{2,5})?(?:\/[^\s?#]*)?(?:\?[^\s#]*)?(?:#[^\s]*)?$/i;

    // Se il campo è vuoto, nessun errore e nessuna validazione
    if (!link) {
        $err.removeClass('invalid-feedback d-block').text('');
        $input.removeClass('is-invalid is-valid');
        return true; // accettato anche se vuoto
    }

    // Primo check: forma “accettabile” anche senza schema
    if (!REGEX_URL.test(link)) {
        $err.addClass('invalid-feedback d-block')
            .text('URL non valido. Esempi: miosito.it, youtube.com/video, 192.168.1.10, localhost:3000, https://example.org');
        $input.addClass('is-invalid').removeClass('is-valid');
        return false;
    }

    // Normalizza: se manca lo schema, aggiungo https:// e aggiorno l’input
    if (!/^[a-z][a-z0-9+.-]*:\/\//i.test(link)) {
        link = 'https://' + link;
        $input.val(link);
    }

    // Verifica finale con l’oggetto URL
    try {
        new URL(link);
    } catch {
        $err.addClass('invalid-feedback d-block').text('URL non valido. Controlla dominio/IP e porta.');
        $input.addClass('is-invalid').removeClass('is-valid');
        return false;
    }

    // OK
    $err.removeClass('invalid-feedback d-block').text('');
    $input.removeClass('is-invalid').addClass('is-valid');
    return true;
}

// Agganci comodi: valida quando esci dal campo e ripulisce il messaggio mentre digiti
$(document).on('blur', '#allegato_link_video', valida_link_video);
$(document).on('input', '#allegato_link_video', function () {
    $('#errore_allegato_link_video').text('').removeClass('invalid-feedback d-block');
    $(this).removeClass('is-invalid is-valid');
});


function check_sezione_ulteriori_dichiarazioni() {
    // 1) Se esiste il validatore modulare, usalo (colora anche header/badge)
    if (window.ValidationUlteriori && typeof window.ValidationUlteriori.validate === 'function') {
        const ok = window.ValidationUlteriori.validate();
        return ok ? 0 : 1; // nei tuoi calcoli sommi numeri: 0 = ok, 1 = errori
    }

    // 2) Fallback minimale (se il modulo non è caricato)
    const section = document.getElementById('ulteriori-dichiarazioni');
    if (!section) return 0;

    const blockImpegno = document.getElementById('ulteriori-dichiarazioni-impegno');
    const blockRend = document.getElementById('ulteriori-dichiarazioni-rendicontazione');

    const isHidden = (node) => {
        if (!node) return false;
        const cs = getComputedStyle(node);
        return cs.display === 'none' || node.classList.contains('d-none');
    };

    let errors = 0;
    section.querySelectorAll('input[type="checkbox"][required]').forEach(chk => {
        const insideImpegno = blockImpegno && blockImpegno.contains(chk);
        const insideRend = blockRend && blockRend.contains(chk);
        const skip =
            (insideImpegno && isHidden(blockImpegno)) ||
            (insideRend && isHidden(blockRend)) ||
            chk.disabled;

        const err = document.getElementById('errore_' + chk.id);

        if (skip) {
            chk.classList.remove('is-invalid', 'is-valid');
            if (err) err.textContent = '';
            return;
        }

        if (!chk.checked) {
            errors++;
            chk.classList.add('is-invalid'); chk.classList.remove('is-valid');
            if (err) err.innerHTML = '<small class="text-danger">Campo obbligatorio.</small>';
        } else {
            chk.classList.remove('is-invalid'); chk.classList.add('is-valid');
            if (err) err.textContent = '';
        }
    });

    // Badge + header (coerente col resto del form)
    const string_errori = errors === 1 ? ' errore' : ' errori';
    const string_verbo = errors === 1 ? ' è ' : ' sono ';

    const $badge = $('#validazione_ulteriori_dichiarazioni');
    const $btn = $('#ulteriori-dichiarazioni .accordion-header button');

    $badge.removeClass('badge text-bg-error text-bg-success');
    $btn.removeClass('background-color-error-accordion background-color-success-accordion');

    if (errors === 0) {
        $badge.text('Sezione Compilata Correttamente').addClass('badge text-bg-success');
        $btn.addClass('background-color-success-accordion');
    } else {
        $badge.text('Vi ' + string_verbo + errors + string_errori).addClass('badge text-bg-error');
        $btn.addClass('background-color-error-accordion');
    }

    return errors === 0 ? 0 : 1;
}

function check_sezione_privacy() {
    // 1) Se esiste il validatore modulare, usalo (ritorna boolean)
    if (window.ValidationPrivacy && typeof window.ValidationPrivacy.validate === 'function') {
        const ok = window.ValidationPrivacy.validate();
        return ok ? 0 : 1;
    }

    // 2) Fallback: controllo manuale del checkbox
    let errori_privacy = 0;

    const $chk = $('#checkbox-policy'); // id previsto nel validator modulare
    const $err = $('#errore_accettazione_privacy');

    // Se per qualche motivo non c’è l’id, prova col name
    const isChecked =
        ($chk.length ? $chk.prop('checked') : $('input[name=checkbox-policy]').is(':checked')) === true;

    if (!isChecked) {
        ($chk.length ? $chk : $('input[name=checkbox-policy]'))
            .addClass('is-invalid').removeClass('is-valid');
        $err.addClass('invalid-feedback').html('<small class="text-danger">Devi accettare obbligatoriamente la privacy policy.</small>');
        errori_privacy++;
    } else {
        ($chk.length ? $chk : $('input[name=checkbox-policy]'))
            .removeClass('is-invalid').addClass('is-valid');
        $err.removeClass('invalid-feedback').text('');
    }

    // 3) Aggiorna i tuoi badge/classi custom (coerente col resto del form)
    const string_errori = errori_privacy === 1 ? ' errore' : ' errori';
    const string_verbo = errori_privacy === 1 ? ' è ' : ' sono ';

    $('#validazione_sezione_privacy_policy')
        .removeClass('badge text-bg-error text-bg-success');
    $('#privacy-policy .accordion-header button')
        .removeClass('background-color-error-accordion background-color-success-accordion');

    if (errori_privacy === 0) {
        $('#validazione_sezione_privacy_policy')
            .text('Sezione Compilata Correttamente')
            .addClass('badge text-bg-success');
        $('#privacy-policy .accordion-header button')
            .addClass('background-color-success-accordion');
    } else {
        $('#validazione_sezione_privacy_policy')
            .text('Vi ' + string_verbo + errori_privacy + string_errori)
            .addClass('badge text-bg-error');
        $('#privacy-policy .accordion-header button')
            .addClass('background-color-error-accordion');
    }

    return errori_privacy;
}
function getFormattedDate(date) {
    var date = date.split("-");
    var anno = date[0];
    var mese = date[1];
    var giorno = date[2];

    return giorno + '/' + mese + '/' + anno;
}

// ======================
// TUA FUNZIONE PDF (INVARIATA tranne rimozione download privacy)
// ======================
function crea_file_pdf(codice, file_names) {
    function ensureSpace(doc, y, needed = 60) {
        // spazio minimo per data/firma/note
        if (y + needed > 280) {        // 280 ≈ margine inferiore pagina A4
            doc.addPage();
            return 20;                   // riparti dall'alto della nuova pagina
        }
        return y;
    }

    function printFirmaBlock(doc, y) {
        const ph = doc.internal.pageSize.getHeight(); // mm
        const footerReserve = 8;   // spazio riservato al footer
        const blockHeight = 55;   // altezza stimata blocco firma+note
        const minTopMargin = 20;   // margine superiore se va su nuova pagina

        // y target: blocco ancorato dal basso
        const targetStart = ph - footerReserve - blockHeight;

        // se il contenuto attuale supererebbe lo spazio utile, vai a nuova pagina
        if (y > targetStart) {
            doc.addPage();
            y = minTopMargin;
        }

        // usa il più basso tra y e targetStart (così scendi verso il fondo)
        y = Math.max(y, targetStart);

        // ——— contenuto blocco ———
        doc.setFont('PTSans', 'italic');
        doc.setFontSize(11);

        // Riga luogo/data
        const luogo = $("#luogo_per_firma").val();
        const data = $("#data_per_firma").val() ? getFormattedDate($("#data_per_firma").val()) : null;
        const riga = (luogo && data)
            ? `Li ${luogo}     Data ${data}`
            : 'Li ___________________     Data ___________________';

        doc.text(13, y + 10, riga);

        // Firma a destra
        doc.setFont('PTSans', 'normal');
        doc.text('Firma del Rappresentante legale', 120, y + 35);

        // Note
        doc.setFont('PTSans', 'italic');
        doc.text(13, y + 60 - 15, '*Nella certezza di avere applicato al meglio le mie capacità professionali nella redazione della presente perizia,');
        doc.text(13, y + 60 - 10, 'confermo, sotto la mia responsabilità, l’autenticità e la certezza dei contenuti della relazione.');

        return y + blockHeight;
    }
    function stampa_testo_multiriga(doc, testo, x, currentY, larghezzaMax = 180, interlinea = 7) {
        const righe = doc.splitTextToSize(testo, larghezzaMax);
        righe.forEach(riga => {
            if (currentY >= 280) {
                doc.addPage();
                currentY = 20;
            }
            doc.text(riga, x, currentY);
            currentY += interlinea;
        });
        return currentY;
    }
    function addCheckBoxLine(doc, x, currentY, text) {
        // Gestione della posizione verticale
        currentY += 6;
        if (currentY > 275) {
            doc.addPage();
            currentY = 20;
        }

        try {
            // Crea la checkbox
            var checkBox = new jspdf.AcroFormCheckBox();
            checkBox.maxFontSize = 9;
            checkBox.readOnly = true;
            checkBox.height = 3;
            checkBox.width = 3;
            checkBox.x = x;
            checkBox.y = currentY - 3;
            checkBox.checked = true; // la spunta visivamente
            checkBox.value = "Yes";
            doc.addField(checkBox);
        } catch (e) {
            // Se AcroForm non disponibile, fallback
            doc.text("☑︎", x, currentY);
        }

        // Testo accanto alla checkbox
        doc.setFont('PTSans', 'bold');
        doc.setFontSize(12);
        const lines = doc.splitTextToSize(text, 165);
        let textY = currentY;
        lines.forEach((line, idx) => {
            if (textY > 275) { doc.addPage(); textY = 20; }
            doc.text(line, x + 6, textY);
            textY += 5;
        });

        return textY;
    }

    function addDichiarazioni(doc, x, currentY) {
        const tipo = $('input[name=tipo_richiesta]:checked').val();

        const docContabile = $('#checkbox-documentazione').is(':checked');
        const mendacita = $('#checkbox-mendacita').is(':checked');
        const ivaNonRecup = $('#checkbox-iva').is(':checked');

        // ✅ nuovi checkbox sezione rendicontazione
        const noAltroContr = $('#chk_no_altro_contributo').is(':checked');
        const speseUnivoche = $('#chk_spese_univoche').is(':checked');

        // --- DICHIARAZIONI "BASE" collegate ai checkbox del form ---
        if (tipo === 'impegno') {
            if (docContabile) {
                currentY = addCheckBoxLine(
                    doc,
                    x,
                    currentY,
                    "di impegnarsi a fornire adeguata e analitica documentazione contabile delle spese che saranno sostenute per la realizzazione dell’iniziativa promozionale."
                );
            }
            if (mendacita) {
                currentY = addCheckBoxLine(
                    doc,
                    x,
                    currentY,
                    "che i dati e le informazioni riportate nella relazione tecnica economica sono veritieri."
                );
            }
        } else if (tipo === 'liquidazione') {

            // IVA non recuperabile
            if (ivaNonRecup) {
                currentY = addCheckBoxLine(
                    doc,
                    x,
                    currentY,
                    "dichiara che le spese rendicontate non sono soggette a IVA recuperabile."
                );
            }

            // ✅ nuovo: nessun altro contributo sulle stesse spese
            if (noAltroContr) {
                currentY = addCheckBoxLine(
                    doc,
                    x,
                    currentY,
                    "dichiara di non aver alcun titolo beneficiato, a copertura delle medesime spese, di altri contributi."
                );
            }

            // ✅ nuovo: spese univocamente inerenti
            if (speseUnivoche) {
                currentY = addCheckBoxLine(
                    doc,
                    x,
                    currentY,
                    "dichiara che le spese sono state sostenute esclusivamente per l’acquisizione di beni e servizi univocamente inerenti all’iniziativa in oggetto."
                );
            }
        }

        // --- NUOVE "ALTRE DICHIARAZIONI" (Allegato 2) per ISTANZA / IMPEGNO ---


        return currentY;
    }

    function addPrivacyNoteBelowAllegati(doc, x, currentY) {
        if (!$('#checkbox-policy').is(':checked')) return currentY;
        currentY = addCheckBoxLine(doc, x, currentY,
            "Dichiaro di aver letto e compreso la Privacy Policy");
        return currentY;
    }
    function footer_prima_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 1');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }

    function footer_seconda_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 2');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }
    function footer_terza_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 3');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }
    function footer_quarta_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 4');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }
    function footer_quinta_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 5');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }
    function footer_sesta_pagina() {
        doc.setFont('PTSans', 'normal');
        doc.text(13, 290, 'Pagina 6');
        doc.text(160, 290, 'Modello di domanda v.' + $("#versione").val());
    }

    function stampaAllegati(doc, x, y, titolo, arr) {
        if (!arr || !arr.length) return y;
        y += 8;
        doc.setFont('PTSans', 'bold');
        doc.text(titolo, x, y);
        doc.setFont('PTSans', 'normal');
        arr.forEach((name) => {
            const righe = doc.splitTextToSize(name, 170);
            righe.forEach((riga, idx) => {
                y += 6;
                if (y > 275) { doc.addPage(); y = 20; }
                doc.text((idx === 0 ? ' - ' : '   ') + riga, x, y);
            });
        });
        return y;
    }

    const gruppiVari = [
        ["Progetto", file_names.allegato_progetto],
        ["Progetto dettagliato dell’iniziativa", file_names.allegato_progetto2], // 👈 AGGIUNTA
        ["Piano Economico", file_names.allegato_piano_economico],
        ["Documento rappresentante", file_names.allegato_documento_identita],
        ["Dichiarazione Gastronomia", file_names.allegato_gastronomia],
        ["Autocertificazione rappresentante", file_names.allegato_autocertificazione],
        ["Statuto", file_names.allegato_statuto],
        ["Antimafia", file_names.allegato_antimafia],
        ["Curricula", file_names.allegato_curricula],
        ["Documento contribuzione (DURC)", file_names.allegato_DURC],
        ["Relazione finale", file_names.allegato_relazione],
        ["Documentazione pubblicitaria", file_names.allegato_documentazione_pubblicitaria],
        ["Dichiarazione assenza altri contributi", file_names.allegato_dichiarazione_no_contributi],
        ["Scostamenti", file_names.allegato_scostamenti],
        ["Foto", file_names.allegato_foto],
        ["Delega del Sindaco", file_names.allegato_delega_sindaco],
    ];

    const gruppiTabella = [
        ["Delibere di affidamento", file_names.delibera_affidamento],
        ["Delibere di pagamento", file_names.delibera_pagamento],
        ["Mandati di pagamento", file_names.mandato_pagamento],
        ["Fatture/Titoli di spesa", file_names.fattura],
        ["Ricevute bonifico/assegno", file_names.ricevuta_bonifico_assegno],
        ["Prospetto di riparto", file_names.prospetto_riparto],
    ];
    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val();
    const tipo_beneficiario = $('input[name=tipo_beneficiario]:checked').val();
    const nome_rappr = $(`#nome_rappr`).val();
    const cognome_rappr = $(`#cognome_rappr`).val();
    const cf_rappr = $(`#cf_rappresentante`).val();
    const dataNascita_rappr = $(`#data_nascita_rappr`).val();
    const luogoNascita_rappr = $(`#luogo_nascita_rappr`).val();
    const provinciaNascita_rappr = $(`#provincia_nascita_rappr`).val();
    const residenza_rappr = $(`#residenza_rappr`).val();
    const provincia_rappr = $(`#provincia_rappr`).val();
    const indirizzo_rappr = $(`#indirizzo_rappr`).val();
    const civico_rappr = $(`#civico_rappr`).val();
    const telefono_rappr = $(`#telefono_rappr`).val();
    const forma_giuridica_ben = $('#forma_giuridica_' + tipo_beneficiario + ' option:selected').text().trim();

    const denominazione_ben = $(`#denominazione_beneficiario`).val();
    const cuaa_ben = codice;
    const residenza_ben = $(`#sede_beneficiario`).val();
    const provincia_ben = $(`#sede_provincia_beneficiario`).val();
    const indirizzo_ben = $(`#sede_indirizzo_beneficiario`).val();
    const civico_ben = $(`#civico_sede_beneficiario`).val();
    const email_ben = $(`#email_beneficiario`).val();
    const pec_ben = $(`#pec_beneficiario`).val();
    const telefono = $(`#telefono_beneficiario`).val();

    const titolo_iniziativa = $(`#titolo_iniziativa`).val();
    const data_inizio = $(`#data_inizio`).val();
    const data_fine = $(`#data_fine`).val();
    const sede_iniziativa = $(`#sede_iniziativa`).val();
    const sede_provincia_iniziativa = $(`#sede_provincia_iniziativa`).val();
    const obiettivi_iniziativa = $(`#obiettivi_iniziativa`).val();
    const descrizione_iniziativa = $(`#descrizione_iniziativa`).val();

    const contributo_ammesso = $(`#contributo_ammesso`).val();
    const linea = $(`#selezione_tipo_linea`).val();

    const iban = $(`#iban`).val();
    const istituto_credito = $(`#istituto-credito`).val();
    const agenzia_banca = $(`#agenzia_banca`).val();

    let importo_totale;
    var righe_investimenti = [];
    var righe_tabella = $("#investimenti tbody tr");
    var counter = 0;

    var header = [
        "Oggetto della spesa",
        "Data del pagamento",
        "Beneficiario",
        "CF/P.IVA",
        "Importo",
        "Fattura N°/Titolo",
    ];
    righe_tabella.each(function () {
        var id = $(this).attr("id");
        if (counter == 0) {
            righe_investimenti.push(header);
        }
        if (id.substring(0, 14) == "oggetto_spesa_") {
            var oggetto_spesa = $(this).find("td:eq(0) input");
            var data_pagamento = $(this).find("td:eq(1) input");
            var beneficiario = $(this).find("td:eq(2) input");
            var cf_piva = $(this).find("td:eq(3) input");
            var importo = $(this).find("td:eq(4) input");
            var fattura_titolo = $(this).find("td:eq(5) input");

            righe_investimenti.push([
                oggetto_spesa.val(), getFormattedDate(data_pagamento.val()), beneficiario.val(), cf_piva.val(),
                importo.val(), fattura_titolo.val(),
            ]);
        }
        if (id == "totale_spdi") {
            importo_totale = $("#importo_totale").attr("valore");
            righe_investimenti.push([
                "Totale", "", "", "", importo_totale, ""
            ]);
        }
        counter++;
    });


    const { jsPDF } = window.jspdf;
    const doc = new jsPDF();
    let img = new Image();
    img = $("#png_regione_siciliana").attr("src");
    doc.addImage(img, 'png', 93, 5, 24, 30);
    doc.setFontSize('12');
    doc.setFont('PTSans', 'italic');
    doc.text("Regione Siciliana", 105, 38, 'center', '');

    /*==== PRIMA PAGINA ====*/
    const titolo_nuovo_prima_riga = "ASSESSORATO REGIONALE DELL’AGRICOLTURA, DELLO SVILUPPO";
    const titolo_nuovo_seconda_riga = "RURALE E DELLA PESCA MEDITERRANEA";
    const titolo_nuovo_terza_riga = "DIPARTIMENTO REGIONALE DELL’AGRICOLTURA";
    doc.text(titolo_nuovo_prima_riga, 104, 45, 'center', '');
    doc.text(titolo_nuovo_seconda_riga, 104, 50, 'center');
    doc.text(titolo_nuovo_terza_riga, 104, 55, 'center');

    //const titolo_prima_riga = "Legge n. 499 del 23.12.1999. Iniziative di promozione e valorizzazione dei prodotti agricoli e agroalimentari.";
    // const titolo_seconda_riga = "Servizio 5 - Qualità e marketing brand.";
    doc.setFont('PTSans', 'normal');
    doc.setFontSize('12');
    // doc.text(titolo_prima_riga, 12, 65);
    //doc.setFont('PTSans', 'center');
    // doc.text(titolo_seconda_riga, 11, 70);

    doc.setFont('PTSans', 'bold');
    doc.setFontSize('12');
    const titoloFormato = (tipo_richiesta === 'liquidazione')
        ? 'Format di rendicontazione'
        : 'Format di istanza';
    doc.text(titoloFormato, 104, 80, 'center', '');
    var currentY = 105;
    var sumY = 7;
    var x = 13;
    doc.text("SEZIONE ANAGRAFICA", 104, currentY, 'center', '');
    doc.setFont('PTSans', 'normal');
    doc.setFontSize('12');
    doc.text("Il/La sottoscritto/a:", x, (currentY += sumY) * 1);
    doc.text("Nome:  " + nome_rappr, x, (currentY += sumY) * 1);
    doc.text("Cognome:  " + cognome_rappr, x, (currentY += sumY) * 1);
    doc.text("Codice fiscale:  " + cf_rappr, x, (currentY += sumY) * 1);  //  NUOVO
    doc.text("Data di nascita:  " + getFormattedDate(dataNascita_rappr), x, (currentY += sumY) * 1);
    doc.text("Luogo di nascita:  " + luogoNascita_rappr + " (" + provinciaNascita_rappr + ")", x, (currentY += sumY) * 1);
    doc.text("Residente a:  " + residenza_rappr + " (" + provincia_rappr + ")", x, (currentY += sumY) * 1);
    doc.text("Indirizzo:  " + indirizzo_rappr + " n." + civico_rappr, x, (currentY += sumY) * 1);
    doc.text("Telefono/Cellulare:  " + telefono_rappr, x, (currentY += sumY) * 1);
    doc.text("in qualità di rappresentante legale di: ", x, (currentY += sumY * 1.5) * 1);
    doc.text("Forma giuridica:  " + forma_giuridica_ben, x, (currentY += sumY) * 1);
    doc.text("Denominazione:  " + denominazione_ben, x, (currentY += sumY) * 1);
    doc.text("CUAA:  " + cuaa_ben, x, (currentY += sumY) * 1);
    doc.text("Luogo sede legale:  " + residenza_ben + " (" + provincia_ben + ")", x, (currentY += sumY) * 1);
    doc.text("Indirizzo:  " + indirizzo_ben + " n." + civico_ben, x, (currentY += sumY) * 1);
    doc.text("Email:  " + email_ben, x, (currentY += sumY) * 1);
    doc.text("PEC:  " + pec_ben, x, (currentY += sumY) * 1);
    doc.text("Telefono/Cellulare:  " + telefono, x, (currentY += sumY) * 1);


    //footer_prima_pagina();
    /*==== PRIMA PAGINA ====*/

    /*==== SECONDA PAGINA ====*/
    doc.addPage();
    var currentY = 20;
    var sumY = 7;
    var x = 13;


    doc.setFont('PTSans', 'bold');
    doc.text("SEZIONE INIZIATIVA", 104, (currentY += sumY) * 1, 'center', '');
    doc.setFont('PTSans', 'normal');
    doc.setFontSize('12');
    doc.text("per la realizzazione della manifestazione: ", x, (currentY += sumY) * 1);
    doc.text("Titolo Iniziativa:  " + titolo_iniziativa, x, (currentY += sumY * 1.5) * 1);
    doc.text("Data inizio:  " + getFormattedDate(data_inizio), x, (currentY += sumY) * 1);
    doc.text("Data fine:  " + getFormattedDate(data_fine), x, (currentY += sumY) * 1);
    doc.text("Luogo iniziativa:  " + sede_iniziativa + " (" + sede_provincia_iniziativa + ")", x, (currentY += sumY) * 1);

    //currentY = stampa_testo_multiriga(doc, "Obiettivi:  " + obiettivi_iniziativa, x, (currentY += sumY) * 1);
    currentY = stampa_testo_multiriga(doc, "Descrizione sintetica dell'intervento:  " + descrizione_iniziativa, x, (currentY += sumY) * 1);

    // doc.text("Obiettivi:  " + obiettivi_iniziativa, x, (currentY+=sumY)*1);
    // doc.text("Descrizione sintetica dell'intervento:  " + descrizione_iniziativa, x, (currentY+=sumY)*1);
    //footer_seconda_pagina();
    /*==== SECONDA PAGINA ====*/

    doc.addPage();
    var currentY = 20;
    var sumY = 7;
    var x = 13;
    if (tipo_richiesta === "impegno") {
        /*====  TIPO RICHIESTA: IMPEGNO ====*/
        /*==== TERZA PAGINA ====*/
        doc.setFont('PTSans', 'bold');
        doc.text("SEZIONE RICHIESTA CONTRIBUTO", 104, (currentY += sumY) * 1, 'center', '');
        doc.setFont('PTSans', 'normal');
        doc.setFontSize('12');
        doc.text("richiede un contributo pari a € " + contributo_ammesso + " per la suddetta iniziativa, nell'ambito della Linea " + linea, x, (currentY += sumY * 1.5) * 1);
        // footer_terza_pagina();

        doc.addPage();
        var currentY = 20;
        var sumY = 7;
        var x = 13;
        doc.setFont('PTSans', 'bold');
        doc.text("SEZIONE ALLEGATI", 104, currentY, 'center', '');
        // Elenca solo gli allegati effettivamente presenti
        gruppiVari.forEach(([titolo, arr]) => {
            if (Array.isArray(arr) && arr.length) {
                currentY = stampaAllegati(doc, x, currentY, titolo, arr);
            }
        });
        gruppiTabella.forEach(([titolo, arr]) => {
            if (Array.isArray(arr) && arr.length) {
                currentY = stampaAllegati(doc, x, currentY, titolo, arr);
            }
        });
        doc.setFont('PTSans', 'normal');
        doc.setFontSize('12');
        currentY += 10;  // lascia uno spazio prima delle dichiarazioni
        currentY = addDichiarazioni(doc, x, currentY);
        currentY = addPrivacyNoteBelowAllegati(doc, x, currentY);
        //footer_quarta_pagina();
        /*==== TERZA PAGINA ====*/
        /*====  TIPO RICHIESTA: IMPEGNO ====*/
    } else if (tipo_richiesta === "liquidazione") {
        /*====  TIPO RICHIESTA: LIQUIDAZIONE ====*/
        /*==== TERZA PAGINA ====*/
        doc.setFont('PTSans', 'bold');
        doc.text("SEZIONE DATI BANCARI", 104, (currentY += sumY) * 1, 'center', '');
        doc.setFontSize('12');
        doc.setFont('PTSans', 'normal');
        doc.text("IBAN:  " + iban, x, (currentY += sumY) * 1);
        doc.text("Istituto di Credito:  " + istituto_credito, x, (currentY += sumY) * 1);
        doc.text("Agenzia:  " + agenzia_banca, x, (currentY += sumY) * 1);
        doc.setFont('PTSans', 'bold');
        //footer_terza_pagina();
        /*==== TERZA PAGINA ====*/

        /*==== QUARTA PAGINA ====*/
        doc.addPage();
        var currentY = 20;
        var sumY = 7;
        var x = 13;
        doc.setFont('PTSans', 'bold');
        doc.text("SEZIONE LIQUIDAZIONE SPESE", 104, currentY, 'center', '');
        doc.setFont('PTSans', 'normal');
        doc.setFontSize('12');
        doc.text("richiede la liquidazione dell'importo pari a € " + importo_totale + ", corrispondenti al totale delle spese effettivamente sostenute", x, (currentY += sumY * 1.5) * 1);
        doc.text("come da sottostante partitario di spesa: ", x, (currentY += sumY * 1.5) * 1);

        doc.setFont('PTSans', 'bold');
        doc.text("Tab.1 - Partitario di spesa", x, (currentY += sumY + 2) * 1);
        doc.setFont('PTSans', 'normal');
        doc.setFontSize('11');
        doc.autoTable({
            startY: currentY,
            body: righe_investimenti,
            margin: { top: 20, right: 13, bottom: 0, left: 13 } // bottom 0 = niente spazio sotto
        });
        // footer_quarta_pagina();
        /*==== QUARTA PAGINA ====*/

        /*==== QUINTA PAGINA ====*/
        doc.addPage();
        var currentY = 20;
        var sumY = 7;
        var x = 13;
        doc.setFont('PTSans', 'bold');
        doc.text("SEZIONE ALLEGATI", 104, currentY, 'center', '');
        // Elenca solo gli allegati effettivamente presenti
        gruppiVari.forEach(([titolo, arr]) => {
            if (Array.isArray(arr) && arr.length) {
                currentY = stampaAllegati(doc, x, currentY, titolo, arr);
            }
        });
        gruppiTabella.forEach(([titolo, arr]) => {
            if (Array.isArray(arr) && arr.length) {
                currentY = stampaAllegati(doc, x, currentY, titolo, arr);
            }
        });
        currentY += 10;  // lascia uno spazio prima delle dichiarazioni
        currentY = addDichiarazioni(doc, x, currentY);
        currentY = addPrivacyNoteBelowAllegati(doc, x, currentY);
        // footer_quinta_pagina();
        /*==== QUINTA PAGINA ====*/
        /*====  TIPO RICHIESTA: LIQUIDAZIONE ====*/
    }

    let versione = $("#versione").val();
    versione = versione.replace(".", "_");
    // Vai all’ultima pagina e stampa il blocco firme
    // === Firma dinamica: calcolo dell'ultima Y usata ===
    doc.setPage(doc.getNumberOfPages());

    let lastY = 20;
    // se esiste una variabile currentY ancora in scope, usala come base
    if (typeof currentY === 'number') lastY = Math.max(lastY, currentY);
    // se è stata stampata una tabella, usa anche la sua Y finale
    if (doc.lastAutoTable && doc.lastAutoTable.finalY) {
        lastY = Math.max(lastY, doc.lastAutoTable.finalY + 10);
    }
    // 2) Footer davvero incollato in fondo a TUTTE le pagine
    function addPageNumbers(doc) {
        const total = doc.getNumberOfPages();
        const versione = $("#versione").val();
        const pw = doc.internal.pageSize.getWidth();
        const ph = doc.internal.pageSize.getHeight();

        const marginX = 13;   // margine orizzontale
        const y = ph - 2;     // 2 mm dal bordo fisico

        for (let i = 1; i <= total; i++) {
            doc.setPage(i);
            doc.setFont('PTSans', 'normal');
            doc.setFontSize(10);

            // sinistra
            doc.text(`Pagina ${i} di ${total}`, marginX, y, { baseline: 'bottom' });

            // destra
            doc.text(`Modello di domanda v.${versione}`, pw - marginX, y, {
                align: 'right',
                baseline: 'bottom'
            });
        }
    }
    // Stampa data/firma con gestione automatica dello spazio/pagina
    printFirmaBlock(doc, lastY);
    addPageNumbers(doc);
    const blob = doc.output("blob");
    const filename = cuaa_ben + "_Modulo_Richiesta_" + versione + ".pdf";
    if (window.__currentZipFolder) {
        window.__currentZipFolder.file(filename, blob);  // metti nel tuo ZIP
    } else {
        saveAs(blob, filename); // fallback, se non stai creando ZIP
    }    // *** RIMOSSO il download separato della privacy ***
}


function getTipoBeneficiarioL() {
    const ben = $('input[name=tipo_beneficiario]:checked').val() || '';
    // ben è 'a', 'b', 'c', 'd', 'e', 'f', 'g'

    if (!ben) return '';

    // A, B, C -> COMUNI PUBBLICI
    if (['a', 'b', 'c'].includes(ben)) {
        return 'comuni';
    }

    // D, E, F, G -> ASSOCIAZIONI / PRIVATI
    if (['d', 'e', 'f', 'g'].includes(ben)) {
        return 'associazioni';
    }

    return '';
}

function download_allegati_vari(codice) {
    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val() || '';
    const tipo_beneficiario = getTipoBeneficiarioL();

    // Sempre
    download(codice, "allegato_progetto", null, "Progetto");
    // Delega del Sindaco: opzionale ma ZIP solo se:
    //    - beneficiario è Comune (lettera a/b/c)
    //    - è stata effettivamente caricata
    const benLetter = $('input[name=tipo_beneficiario]:checked').val() || ''; // 'a'..'g'
    const formaTxt = $('#forma_giuridica_' + benLetter + ' option:selected')
        .text()
        .trim()
        .toLowerCase();

    const delegaInput = document.getElementById('allegato_delega_sindaco');
    const hasDelega =
        delegaInput &&
        delegaInput.files &&
        delegaInput.files.length > 0;

    // solo se la forma giuridica inizia con "comune" E il file esiste
    if (formaTxt.startsWith('comune') && hasDelega) {
        download(codice, "allegato_delega_sindaco", null, "Delega_Sindaco");
    }

    // --- resto del tuo codice invariato ---
    if (tipo_richiesta === "impegno") {
        download(codice, "allegato_progetto2", null, "Progetto_Allegati_Iniziativa"); // 👈 AGGIUNTA
        download(codice, "allegato_piano_economico", null, "Piano_Economico");
        download(codice, "allegato_documento_identita", null, "Documento_Rappresentante");
        download(codice, "allegato_gastronomia", null, "Dichiarazione_Gastronomia");

        if (tipo_beneficiario === "associazioni") {
            download(codice, "allegato_autocertificazione", null, "Dichiarazione_Rappresentante");
            download(codice, "allegato_statuto", null, "Statuto");
            download(codice, "allegato_antimafia", null, "Antimafia");
            download(codice, "allegato_curricula", null, "Curricula");
            download(codice, "allegato_DURC", null, "Documento_Contribuzione");
        }
    } else if (tipo_richiesta === "liquidazione") {
        download(codice, "allegato_relazione", null, "Relazione_Finale");
        download(codice, "allegato_documentazione_pubblicitaria", null, "Documentazione_Pubblicitaria");
        download(codice, "allegato_dichiarazione_no_contributi", null, "Dichiarazione_Beneficiario_Contributi");

        const scostEl = document.getElementById('allegato_scostamenti');
        if (scostEl?.files?.length > 0) {
            download(codice, "allegato_scostamenti", null, "Scostamenti");
        }
        download(codice, "allegato_foto", null, "Foto");
    }
}

function download_allegati_tabella(codice) {
    download(codice, null, "delibera_affidamento", "Delibera_Affidamento");
    download(codice, null, "delibera_pagamento", "Delibera_Pagamento");
    download(codice, null, "mandato_pagamento", "Mandato_Pagamento");
    download(codice, null, "fattura", "Fattura");
    download(codice, null, "ricevuta_bonifico_assegno", "Ricevuta_Bonifico_Assegno");
    download(codice, null, "prospetto_riparto", "Prospetto_Riparto");
}

function download_file_privacy(codice) {
    var versione = $("#versione").val();
    versione = versione.replace(".", "_");
    var a = document.getElementById('pdf_privacy_policy');
    a.download = codice + '_Privacy_Policy_' + versione + '.pdf';
    a.click();
}

function download(codice, el_id, el_name, file_name) {
    var versione = $("#versione").val();
    versione = versione.replace(".", "_");
    if (el_id) {
        var element = document.getElementById(el_id);
        if (!element || !element.files || !element.files[0]) {
            // Nessun file caricato → allegato opzionale: NON bloccare tutto
            return;
        }

        var file = element.files[0];
        var ext = file.name.split('.').pop().toLowerCase();
        var name = `${codice}_${file_name}_${versione}.${ext}`;
        saveAs(file, name);
        file_names[el_id].push(name);
    } else if (el_name) {
        var index = 1;
        var input_files = document.querySelectorAll(`input[type="file"][name="${el_name}"]`);
        if (input_files.length > 0) {
            input_files.forEach(input => {
                var file = input.files[0];
                if (file) {
                    const originalName = file.name;               // es. "Delibera.docx"
                    const dotIndex = originalName.lastIndexOf('.');
                    const ext = dotIndex !== -1 ? originalName.substring(dotIndex) : ''; // ".docx"

                    // 🔹 nome nello ZIP / download, ma con estensione VERA
                    const name = `${codice}_${file_name}_${index}_${versione}${ext}`;

                    // non tocco i byte del file, uso direttamente l’originale
                    saveAs(file, name);

                    file_names[el_name].push(name);
                    index++;
                }
            });
        }
    }
}


function check_allegati_tabella() {
    const $table = $('#allegati_investimenti'); // <-- usa l'ID reale della tabella
    if (!$table.length || !$table.is(':visible')) return 0;

    const requiredPerRiga = [
        'delibera_affidamento',
        'delibera_pagamento',
        'mandato_pagamento',
        'fattura',
        'ricevuta_bonifico_assegno'
    ];

    let errori = 0;

    $table.find('tbody tr').each(function () {
        const $tr = $(this);

        function ko($inp, msg) {
            const $err = $inp.closest('td').find('[class*="errore_"], .invalid-feedback').first();
            $inp.addClass('is-invalid').removeClass('is-valid');
            if ($err.length) $err.html('<small class="text-danger">' + msg + '</small>');
            errori++;
        }
        function ok($inp) {
            const $err = $inp.closest('td').find('[class*="errore_"], .invalid-feedback').first();
            $inp.removeClass('is-invalid').addClass('is-valid');
            if ($err.length) $err.text('');
        }

        // campi sempre obbligatori per riga
        requiredPerRiga.forEach(name => {
            const $inp = $tr.find(`input[type="file"][name="${name}"]`).filter(':enabled:visible').first();
            if (!$inp.length) return;                 // se la colonna non esiste in questa riga, salta
            const hasFile = $inp[0].files && $inp[0].files.length > 0;
            if (!hasFile) ko($inp, 'Documento obbligatorio.'); else ok($inp);
        });

        // Prospetto di riparto: controlla solo se la cella ha un input file
        const $prospetto = $tr.find(`input[type="file"][name="prospetto_riparto"]`).filter(':enabled:visible').first();
        if ($prospetto.length) {
            const hasFile = $prospetto[0].files && $prospetto[0].files.length > 0;
            if (!hasFile) ko($prospetto, 'Prospetto di riparto obbligatorio.'); else ok($prospetto);
        }
    });

    if (typeof paintHeaderRendSpese === 'function') paintHeaderRendSpese(errori);
    return errori; // ora: 2 righe tutte vuote => 10 o 12 a seconda del prospetto
}