function valida_mail(email) {
  var email_reg = /^[A-Z0-9a-z._%+-]+@[A-Za-z0-9.-]+\.[A-Za-z]{2,6}$/;
  return email_reg.test(email);
}
var reg_nome_cognome = /^[a-zA-ZàèéìòùÀÈÉÌÒÙ\-_ ’'‘ÆÐƎƏƐƔĲŊŒẞÞǷȜæðǝəɛɣĳŋœĸſßþƿȝĄƁÇĐƊĘĦĮƘŁØƠŞȘŢȚŦŲƯY̨Ƴąɓçđɗęħįƙłøơşșţțŧųưy̨ƴÁÀÂÄǍĂĀÃÅǺĄÆǼǢƁĆĊĈČÇĎḌĐƊÐÉÈĖÊËĚĔĒĘẸƎƏƐĠĜǦĞĢƔáàâäǎăāãåǻąæǽǣɓćċĉčçďḍđɗðéèėêëěĕēęẹǝəɛġĝǧğģɣĤḤĦIÍÌİÎÏǏĬĪĨĮỊĲĴĶƘĹĻŁĽĿʼNŃN̈ŇÑŅŊÓÒÔÖǑŎŌÕŐỌØǾƠŒĥḥħıíìiîïǐĭīĩįịĳĵķƙĸĺļłľŀŉńn̈ňñņŋóòôöǒŏōõőọøǿơœŔŘŖŚŜŠŞȘṢẞŤŢṬŦÞÚÙÛÜǓŬŪŨŰŮŲỤƯẂẀŴẄǷÝỲŶŸȲỸƳŹŻŽẒŕřŗſśŝšşșṣßťţṭŧþúùûüǔŭūũűůųụưẃẁŵẅƿýỳŷÿȳỹƴźżžẓ]*$/;
var reg_luogo_nascita_residenza = /^[A-Za-zàèéìòùÀÈÉÌÒÙ\s\-']{2,}$/;
var reg_indirizzo = /^[A-Za-z0-9àèéìòùÀÈÉÌÒÙ\s\-\.,']{3,}$/;
var reg_civico = /^\d+(\/[a-zA-Z])?$/;
var reg_mesi_due_cifre = /^\d{1,2}$/;


function controllaCFPIVA(sValue) {
  var bRc = true;
  var iOdd = 0;
  var iEven = 0;
  var iDouble = 0;
  var iCin = 0;
  var tabellaCF = new Array(36);
  var tabellaCFB = new Array(36);
  var tabellaCFA = new Array(36);
  if (sValue.length === 11) {
    iOdd = sValue.charAt(0) * 1 + sValue.charAt(2) * 1 + sValue.charAt(4) * 1 + sValue.charAt(6) * 1 + sValue.charAt(8) * 1;
    for (var i = 1; i < 11; i = i + 2) {
      iDouble = sValue.charAt(i) * 2;
      if (iDouble > 9)
        iEven += iDouble % 10 + 1;
      else
        iEven += iDouble;
    }
    iCin = (10 - (iEven + iOdd) % 10) % 10;
    if (iCin === (sValue.charAt(10) * 1))
      return true;
    else
      return false;
  } else {
    if (sValue.length === 16) {
      tabellaCF[0] = '0';
      tabellaCF[1] = '1';
      tabellaCF[2] = '2';
      tabellaCF[3] = '3';
      tabellaCF[4] = '4';
      tabellaCF[5] = '5';
      tabellaCF[6] = '6';
      tabellaCF[7] = '7';
      tabellaCF[8] = '8';
      tabellaCF[9] = '9';
      tabellaCF[10] = 'A';
      tabellaCF[11] = 'B';
      tabellaCF[12] = 'C';
      tabellaCF[13] = 'D';
      tabellaCF[14] = 'E';
      tabellaCF[15] = 'F';
      tabellaCF[16] = 'G';
      tabellaCF[17] = 'H';
      tabellaCF[18] = 'I';
      tabellaCF[19] = 'J';
      tabellaCF[20] = 'K';
      tabellaCF[21] = 'L';
      tabellaCF[22] = 'M';
      tabellaCF[23] = 'N';
      tabellaCF[24] = 'O';
      tabellaCF[25] = 'P';
      tabellaCF[26] = 'Q';
      tabellaCF[27] = 'R';
      tabellaCF[28] = 'S';
      tabellaCF[29] = 'T';
      tabellaCF[30] = 'U';
      tabellaCF[31] = 'V';
      tabellaCF[32] = 'W';
      tabellaCF[33] = 'X';
      tabellaCF[34] = 'Y';
      tabellaCF[35] = 'Z';
      for (var iTab = 0; iTab < 10; iTab++) {
        tabellaCFA[iTab] = iTab;
      }
      for (var iTab = 10; iTab < 36; iTab++)
        tabellaCFA[iTab] = iTab - 10;
      tabellaCFB[0] = 1;
      tabellaCFB[1] = 0;
      tabellaCFB[2] = 5;
      tabellaCFB[3] = 7;
      tabellaCFB[4] = 9;
      tabellaCFB[5] = 13;
      tabellaCFB[6] = 15;
      tabellaCFB[7] = 17;
      tabellaCFB[8] = 19;
      tabellaCFB[9] = 21;
      tabellaCFB[10] = 1;
      tabellaCFB[11] = 0;
      tabellaCFB[12] = 5;
      tabellaCFB[13] = 7;
      tabellaCFB[14] = 9;
      tabellaCFB[15] = 13;
      tabellaCFB[16] = 15;
      tabellaCFB[17] = 17;
      tabellaCFB[18] = 19;
      tabellaCFB[19] = 21;
      tabellaCFB[20] = 2;
      tabellaCFB[21] = 4;
      tabellaCFB[22] = 18;
      tabellaCFB[23] = 20;
      tabellaCFB[24] = 11;
      tabellaCFB[25] = 3;
      tabellaCFB[26] = 6;
      tabellaCFB[27] = 8;
      tabellaCFB[28] = 12;
      tabellaCFB[29] = 14;
      tabellaCFB[30] = 16;
      tabellaCFB[31] = 10;
      tabellaCFB[32] = 22;
      tabellaCFB[33] = 25;
      tabellaCFB[34] = 24;
      tabellaCFB[35] = 23;
      var tot = 0;
      var tmp = '';
      for (var iChar = 0; iChar < 15; iChar++) {
        tmp = sValue.charAt(iChar);
        var j = 0;
        for (j = 0; j < 36; j++) {
          if (tmp === tabellaCF[j])
            break;
        }
        if (j === 36)
          return false;
        if ((iChar % 2) === 0) {
          tot += tabellaCFB[j];
        } else {
          tot += tabellaCFA[j];
        }
      }
      tot %= 26;
      iCin = tabellaCF[tot + 10];
      if (iCin === sValue.charAt(15))
        return true;
      else
        return false;
    } else
      return false;
  }
}

function valida_nome(nome, suffisso) {
  const input = $(`#nome${suffisso}`);
  const errore = $(`#errore_nome${suffisso}`);

  if (nome.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Nome obbligatorio.");
  } else if (nome.length < 2) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Il nome deve avere almeno due caratteri.");
  } else if (!reg_nome_cognome.test(nome)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Hai inserito caratteri non consentiti.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_cognome(cognome, suffisso) {
  const input = $(`#cognome${suffisso}`);
  const errore = $(`#errore_cognome${suffisso}`);

  if (cognome.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Cognome obbligatorio.");
  } else if (cognome.length < 2) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Il cognome deve avere almeno due caratteri.");
  } else if (!reg_nome_cognome.test(cognome)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Hai inserito caratteri non consentiti.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_data_nascita(dataNascita, suffisso) {
  const input = $(`#data_nascita${suffisso}`);
  const errore = $(`#errore_data_nascita${suffisso}`);
  const anno = dataNascita.split("-")[0];

  if (dataNascita === "") {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Data di nascita obbligatoria.");
  } else if (anno < 1900 || anno > 2026) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Data di nascita non valida.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_luogo_nascita(val, suffisso) {
  const input = $(`#luogo_nascita${suffisso}`);
  const errore = $(`#errore_luogo_nascita${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Luogo di nascita obbligatorio.");
  } else if (!reg_luogo_nascita_residenza.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Luogo di nascita non valido.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_provincia_nascita(val, suffisso) {
  const input = $(`#provincia_nascita${suffisso}`);
  const errore = $(`#errore_provincia_nascita${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia di nascita obbligatoria.");
  } else if (!reg_luogo_nascita_residenza.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia di nascita non valida.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_residenza(val, suffisso) {
  const input = $(`#residenza${suffisso}`);
  const errore = $(`#errore_residenza${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Comune di residenza obbligatorio.");
  } else if (!reg_luogo_nascita_residenza.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Comune di residenza non valido.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_provincia(val, suffisso) {
  const input = $(`#provincia${suffisso}`);
  const errore = $(`#errore_provincia${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia obbligatoria.");
  } else if (!reg_luogo_nascita_residenza.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia non valida.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_indirizzo(val, suffisso) {
  const input = $(`#indirizzo${suffisso}`);
  const errore = $(`#errore_indirizzo${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo obbligatorio.");
  } else if (!reg_indirizzo.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo non valido.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_civico(val, suffisso) {
  const input = $(`#civico${suffisso}`);
  const errore = $(`#errore_civico${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Numero civico obbligatorio.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_telefono(val, suffisso) {
  const input = $(`#telefono${suffisso}`);
  const errore = $(`#errore_telefono${suffisso}`);

  if (val.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Recapito obbligatorio.");
  } else if (!/^\+?\d+$/.test(val)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Inserire solo numeri.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}


function valida_denominazione(denominazione, suffisso) {
  const input = $(`#denominazione${suffisso}`);
  const errore = $(`#errore_denominazione${suffisso}`);
  if (denominazione.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Denominazione obbligatoria.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}
function valida_cuua(cuua, suffisso) {
  const input = $(`#cuua${suffisso}`);
  const errore = $(`#errore_cuua${suffisso}`);

  const raw = cuua || "";
  const hasLower = /[a-z]/.test(raw);
  const val = raw.toUpperCase().replace(/[^A-Z0-9]/g, "");

  // forza subito maiuscolo nel campo
  if (val !== raw) input.val(val);

  if (hasLower) {
    input.addClass("is-invalid").removeClass("is-valid");
    errore.addClass("invalid-feedback").text("Codice CUAA errato. Assicurarsi di scriverlo in maiuscolo.");
    return;
  }

  if (val.length === 0) {
    input.addClass("is-invalid").removeClass("is-valid");
    errore.addClass("invalid-feedback").text("Codice CUAA obbligatorio.");
  } else if (!controllaCFPIVA(val)) {
    input.addClass("is-invalid").removeClass("is-valid");
    errore.addClass("invalid-feedback").text("Codice CUAA errato.");
  } else {
    input.removeClass("is-invalid").addClass("is-valid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_sede(sede, suffisso) {
  const input = $(`#sede${suffisso}`);
  const errore = $(`#errore_sede${suffisso}`);
  if (sede.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Sede obbligatoria.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_sede_provincia(provincia, suffisso) {
  const input = $(`#sede_provincia${suffisso}`);
  const errore = $(`#errore_sede_provincia${suffisso}`);
  if (provincia.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia obbligatoria.");
  } else if (!reg_luogo_nascita_residenza.test(provincia)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Provincia non valida.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_sede_indirizzo(indirizzo, suffisso) {
  const input = $(`#sede_indirizzo${suffisso}`);
  const errore = $(`#errore_sede_indirizzo${suffisso}`);
  if (indirizzo.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo della sede legale obbligatorio.");
  } else if (!reg_indirizzo.test(indirizzo)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo non valido.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_sede_civico(civico, suffisso) {
  const input = $(`#civico_sede${suffisso}`);
  const errore = $(`#errore_civico_sede${suffisso}`);
  if (civico.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Numero civico obbligatorio.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_email(email, suffisso) {
  const input = $(`#email${suffisso}`);
  const errore = $(`#errore_email${suffisso}`);

  if (email.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo Email obbligatorio.");
  } else if (!valida_mail(email)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Formato Email errato.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_pec(pec, suffisso) {
  const input = $(`#pec${suffisso}`);
  const errore = $(`#errore_pec${suffisso}`);

  if (pec.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Indirizzo PEC obbligatorio.");
  } else if (!valida_mail(pec)) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Formato PEC errato.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_forma_giuridica(valore) {
  const erroreId = "#errore_forma_giuridica";
  if (!valore || valore.trim() === "") {
    $(erroreId).text("Selezionare una forma giuridica valida.").addClass("text-danger");
  } else {
    $(erroreId).text("").removeClass("text-danger");
  }
}


$(document).on("input change", "input, select", function () {
  const id = $(this).attr("id");
  const valore = $(this).val();
  if (validatoriCampi.hasOwnProperty(id)) {
    validatoriCampi[id](valore, "_" + id.split("_").pop());
  }
});

// PROVINCIA → COMUNE di residenza del rappresentante
$(document).on("change", "#provincia_rappr", function () {
  var provincia = $(this).val();
  var $comune = $("#residenza_rappr");

  // reset comune
  $comune.html("").prop("disabled", true);

  if (!provincia) {
    // Provincia non scelta → errore
    $("#provincia_rappr").addClass("is-invalid");
    $("#errore_provincia_rappr")
      .addClass("invalid-feedback")
      .text("Provincia di residenza obbligatoria.");

    $comune.addClass("is-invalid");
    $("#errore_residenza_rappr")
      .addClass("invalid-feedback")
      .text("Seleziona prima la provincia.");
    return;
  }

  // Provincia OK
  $("#provincia_rappr").removeClass("is-invalid");
  $("#errore_provincia_rappr").removeClass("invalid-feedback").text("");

  // Carico i comuni della provincia (usa appendi_select_comuni che hai già)
  const options = appendi_select_comuni(provincia.toLowerCase());

  $comune.prop("disabled", false);
  $comune.removeClass("is-invalid");
  $("#errore_residenza_rappr").removeClass("invalid-feedback").text("");

  $comune.html(options);
});

// Cambio COMUNE di residenza
$(document).on("change", "#residenza_rappr", function () {
  const val = $(this).val();
  if (!val) {
    $("#residenza_rappr").addClass("is-invalid");
    $("#errore_residenza_rappr")
      .addClass("invalid-feedback")
      .text("Comune di residenza obbligatorio.");
  } else {
    $("#residenza_rappr").removeClass("is-invalid");
    $("#errore_residenza_rappr").removeClass("invalid-feedback").text("");
  }
});


// --- util per badge + colori header (solo classi Bootstrap) ---
function paintHeaderAnagrafica(errorCount) {
  const headerBtn = document.querySelector('#anagrafica .accordion-button');
  const badgeSpan = document.getElementById('validazione_sezione_anagrafica');
  if (!headerBtn || !badgeSpan) return;

  // reset classi
  headerBtn.classList.remove(
    'bg-danger', 'bg-success', 'text-white',
    'background-color-success-accordion', 'background-color-error-accordion'
  );
  badgeSpan.classList.remove('badge', 'text-bg-success', 'text-bg-error');
  badgeSpan.classList.add('badge');

  if (errorCount > 0) {
    headerBtn.classList.add('background-color-error-accordion', 'text-white');
    badgeSpan.classList.add('text-bg-error');
    badgeSpan.textContent = `Vi ${errorCount === 1 ? 'è' : 'sono'} ${errorCount} ${errorCount === 1 ? 'errore' : 'errori'}`;
  } else {
    headerBtn.classList.add('background-color-success-accordion', 'text-white');
    badgeSpan.classList.add('text-bg-success');
    badgeSpan.textContent = 'Sezione Compilata Correttamente';
  }
}
function validaSezioneAnagrafica() {
  const section = document.getElementById('anagrafica');
  if (!section) return true;

  let errorCount = 0;

  const setErr = (el, errEl, msg) => {
    if (!el) return;
    if (msg) {
      el.classList.add('is-invalid'); el.classList.remove('is-valid');
      if (errEl) errEl.innerHTML = `<small class="text-danger">${msg}</small>`;
      errorCount++;
    } else {
      el.classList.remove('is-invalid'); el.classList.add('is-valid');
      if (errEl) errEl.textContent = '';
    }
  };

  // 1) Required generici: ESCLUDI il CUAA (lo validiamo a parte)
  const requiredControls = section.querySelectorAll(
    '.form-control[required]:not(#cuaa_beneficiario)'
  );
  requiredControls.forEach(input => {
    const val = (input.value || '').trim();
    const errBox = document.getElementById('errore_' + input.id);
    setErr(input, errBox, val ? '' : 'Campo obbligatorio.');
  });

  // 2) Forma giuridica: usa il select legato al beneficiario scelto (a..g)
  const fgErr = document.getElementById('errore_forma_giuridica');
  const benChecked = document.querySelector('input[name="tipo_beneficiario"]:checked');

  // reset stato di tutti i select forma giuridica
  ['a', 'b', 'c', 'd', 'e', 'f', 'g'].forEach(lettera => {
    const sel = document.getElementById('forma_giuridica_' + lettera);
    if (sel) sel.classList.remove('is-invalid', 'is-valid');
  });

  if (!benChecked) {
    // nessun beneficiario selezionato → errore forma giuridica “di riflesso”
    errorCount++;
    if (fgErr) {
      fgErr.innerHTML =
        '<small class="text-danger">Selezionare il tipo di beneficiario e la relativa forma giuridica.</small>';
    }
  } else {
    const lettera = benChecked.value; // 'a'..'g'
    const fgSel = document.getElementById('forma_giuridica_' + lettera);
    const val = (fgSel?.value || '').trim();

    if (!fgSel || !val) {
      // beneficiario scelto ma forma giuridica vuota
      errorCount++;
      if (fgErr) {
        fgErr.innerHTML =
          '<small class="text-danger">Selezionare una forma giuridica valida.</small>';
      }
      if (fgSel) {
        fgSel.classList.add('is-invalid');
        fgSel.classList.remove('is-valid');
      }
    } else {
      // ok
      if (fgErr) fgErr.textContent = '';
      fgSel.classList.add('is-valid');
      fgSel.classList.remove('is-invalid');
    }
  }
  // 3) CUAA beneficiario (accetta CF 16 o P.IVA 11)
  const cuaaEl = document.getElementById('cuaa_beneficiario');
  const cuaaErr = document.getElementById('errore_cuaa_beneficiario');
  if (cuaaEl) {
    const val = (cuaaEl.value || '').trim().toUpperCase();
    if (!val) {
      setErr(cuaaEl, cuaaErr, 'Codice CUAA obbligatorio.');
    } else if (!controllaCFPIVA(val)) {
      setErr(cuaaEl, cuaaErr, 'CUAA non valido (inserisci CF a 16 o P.IVA a 11 cifre).');
    } else {
      setErr(cuaaEl, cuaaErr, '');
    }
  }
  // 3-bis) CODICE FISCALE RAPPRESENTANTE LEGALE (solo CF a 16 caratteri)
  const cfEl = document.getElementById('cf_rappresentante');
  const cfErr = document.getElementById('errore_cf_rappresentante');
  if (cfEl) {
    const raw = (cfEl.value || '').trim();
    const val = raw.toUpperCase().replace(/[^A-Z0-9]/g, '');
    if (val !== raw) cfEl.value = val;    // forza maiuscolo e rimuove caratteri strani

    if (!val) {
      setErr(cfEl, cfErr, 'Codice fiscale obbligatorio.');
    } else if (val.length !== 16 || !controllaCFPIVA(val)) {
      setErr(cfEl, cfErr, 'Codice fiscale non valido.');
    } else {
      setErr(cfEl, cfErr, '');
    }
  }


  // 4) Colora header + badge (funzione già tua)
  paintHeaderAnagrafica(errorCount);

  return errorCount === 0;
}
// --- click su "Crea Files": valida e, se errore, apri + scroll ---
document.addEventListener('DOMContentLoaded', () => {
  // niente colore all'avvio: badge vuoto
  const badge = document.getElementById('validazione_sezione_anagrafica');
  if (badge) badge.innerHTML = '';

  document.querySelectorAll('.crea-files').forEach(btn => {
    btn.addEventListener('click', (e) => {
      const ok = validaSezioneAnagrafica();
      if (!ok) {
        e.preventDefault();
        // espandi e scrolla la sezione
        const collapse = document.getElementById('collapseOne');
        if (collapse && !collapse.classList.contains('show') && window.bootstrap?.Collapse) {
          new bootstrap.Collapse(collapse, { toggle: true });
        }
        document.getElementById('anagrafica')?.scrollIntoView({ behavior: 'smooth', block: 'start' });
      }
    });
  });
});


// Validazione live CUAA: blocca minuscole, forza maiuscolo e corregge stato rosso
$(document).on("input blur", "#cuaa_beneficiario", function () {
  const raw = this.value || "";
  const hadLower = /[a-z]/.test(raw);

  // normalizzo: solo maiuscole e numeri
  const upper = raw.toUpperCase().replace(/[^A-Z0-9]/g, "");
  if (upper !== raw) this.value = upper;

  const val = upper.trim();
  const $input = $(this);
  const $err = $("#errore_cuaa_beneficiario");

  // messaggio se prima c'erano minuscole
  if (hadLower) {
    $err
      .addClass("invalid-feedback")
      .html('<small class="text-danger">Codice CUAA errato. Assicurarsi di scriverlo in maiuscolo.</small>');
    $input.addClass("is-invalid").removeClass("is-valid");
    // NON facciamo return: dopo il messaggio controlliamo comunque se ora è valido
  }

  // vuoto
  if (!val) {
    $input.addClass("is-invalid").removeClass("is-valid");
    $err
      .addClass("invalid-feedback")
      .html('<small class="text-danger">Codice CUAA obbligatorio.</small>');
    return;
  }

  // validazione "vera"
  if (!controllaCFPIVA(val)) {
    $input.addClass("is-invalid").removeClass("is-valid");
    $err
      .addClass("invalid-feedback")
      .html('<small class="text-danger">Codice CUAA errato.</small>');
  } else {
    // ✅ CUAA CORRETTO → tolgo il rosso
    $input.removeClass("is-invalid").addClass("is-valid");
    $err.removeClass("invalid-feedback").html("");
  }
});
// Validazione live Codice Fiscale Rappresentante
$(document).on("input blur", "#cf_rappresentante", function () {
  const raw = this.value || "";
  const upper = raw.toUpperCase().replace(/[^A-Z0-9]/g, "");
  if (upper !== raw) this.value = upper;

  const $err = $("#errore_cf_rappresentante");

  if (!upper) {
    $(this).addClass("is-invalid").removeClass("is-valid");
    $err.addClass("invalid-feedback").text("Codice fiscale obbligatorio.");
  } else if (upper.length !== 16 || !controllaCFPIVA(upper)) {
    $(this).addClass("is-invalid").removeClass("is-valid");
    $err.addClass("invalid-feedback").text("Codice fiscale non valido.");
  } else {
    $(this).removeClass("is-invalid").addClass("is-valid");
    $err.removeClass("invalid-feedback").text("");
  }
});


// Quando cambio beneficiario: mostro la forma giuridica corrispondente
$(document).on("change", "input[name=tipo_beneficiario]", function () {
  const lettera = $(this).val(); // 'a'..'g'

  // nascondo tutte
  $(".select-forma-giuridica")
    .addClass("d-none")
    .prop("required", false);   // tolgo required da tutte

  // mostro solo quella collegata al beneficiario scelto
  const $selFg = $("#forma_giuridica_" + lettera);
  if ($selFg.length) {
    $selFg.removeClass("d-none").prop("required", true);
  }
});


function getBeneficiarioKey() {
  return $('input[name=tipo_beneficiario]:checked').val() || '';
}

function isBeneficiarioComune() {
  const key = getBeneficiarioKey();   // 'a','b','c','d','e','f','g'
  if (key !== 'a') return false;      // vale solo per i Comuni

  const forma = $('#forma_giuridica_' + key + ' option:selected')
      .text().trim().toLowerCase();

  return forma.startsWith("comune");  // riconosce "Comune", "Comune di...", ecc.
}

function toggleDelegaSindaco() {
  const show = isBeneficiarioComune();
  const $wrap = $('#wrap_allegato_delega_sindaco');
  const $inp  = $('#allegato_delega_sindaco');
  const $err  = $('#errore_allegato_delega_sindaco');

  if (show) {
    $wrap.removeClass('d-none');
    $inp.removeAttr('required');   // 👈 NON è obbligatoria
  } else {
    $wrap.addClass('d-none');
    $inp.removeAttr('required').val('');
    $inp.removeClass('is-invalid is-valid');
    $err.text('').removeClass('invalid-feedback');
  }
}


// quando cambio beneficiario
$(document).on('change','input[name=tipo_beneficiario]', function () {
    toggleDelegaSindaco();
});

// quando cambio forma giuridica
$(document).on('change','.select-forma-giuridica', function () {
    toggleDelegaSindaco();
});

// all’avvio
$(function(){
    toggleDelegaSindaco();
});