/* validation/validazione_sezione_ulteriori_dichiarazioni.js */
(function () {
  'use strict';

  // Util: header rosso/verde + badge (solo classi Bootstrap)
  // Util: header rosso/verde + badge (come Anagrafica)
  function paintHeader(sectionSelector, badgeSpanId, errorCount) {
    const headerBtn = document.querySelector(`${sectionSelector} .accordion-button`);
    const badgeSpan = document.getElementById(badgeSpanId);
    if (!headerBtn || !badgeSpan) return;

    // reset classi
    headerBtn.classList.remove(
      'bg-danger', 'bg-success', 'text-white',
      'background-color-success-accordion', 'background-color-error-accordion'
    );
    badgeSpan.classList.remove('badge', 'text-bg-success', 'text-bg-error');
    badgeSpan.classList.add('badge');

    if (errorCount > 0) {
      headerBtn.classList.add('background-color-error-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-error');
      badgeSpan.textContent = `Vi ${errorCount === 1 ? 'è' : 'sono'} ${errorCount} ${errorCount === 1 ? 'errore' : 'errori'}`;
    } else {
      headerBtn.classList.add('background-color-success-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-success');
      badgeSpan.textContent = 'Sezione Compilata Correttamente';
    }
  }

  function markOk(el, errBox) {
    el.classList.remove('is-invalid');
    el.classList.add('is-valid');
    if (errBox) errBox.textContent = '';
  }
  function markErr(el, errBox, msg) {
    el.classList.add('is-invalid');
    el.classList.remove('is-valid');
    if (errBox) errBox.innerHTML = `<small class="text-danger">${msg}</small>`;
  }

  // Ritorna true se un nodo è "nascosto" (display:none o d-none)
  function isHidden(node) {
    if (!node) return false;
    const cs = getComputedStyle(node);
    return cs.display === 'none' || node.classList.contains('d-none');
  }

  // --- VALIDAZIONE SEZIONE ULTERIORI DICHIARAZIONI ---
  function validaSezioneUlterioriDichiarazioni() {
    const section = document.getElementById('ulteriori-dichiarazioni');
    if (!section) return true;

    let errorCount = 0;

    // Blocchi alternativi
    const blockImpegno = document.getElementById('ulteriori-dichiarazioni-impegno');
    const blockRend = document.getElementById('ulteriori-dichiarazioni-rendicontazione');

    // Prendi tutti i checkbox required della sezione
    const allRequired = section.querySelectorAll('input[type="checkbox"][required]');

    allRequired.forEach(chk => {
      // Se il checkbox sta in un blocco nascosto → ignoralo
      const insideImpegno = blockImpegno && blockImpegno.contains(chk);
      const insideRend = blockRend && blockRend.contains(chk);
      const skipForHidden =
        (insideImpegno && isHidden(blockImpegno)) ||
        (insideRend && isHidden(blockRend));

      if (skipForHidden || chk.disabled) {
        chk.classList.remove('is-invalid', 'is-valid');
        const errSkip = document.getElementById('errore_' + chk.id);
        if (errSkip) errSkip.textContent = '';
        return;
      }

      const err = document.getElementById('errore_' + chk.id);
      if (!chk.checked) {
        errorCount++;
        markErr(chk, err, 'Campo obbligatorio.');
      } else {
        markOk(chk, err);
      }
    });

    // Colora header + badge
    paintHeader('#ulteriori-dichiarazioni', 'validazione_ulteriori_dichiarazioni', errorCount);
    return errorCount === 0;
  }

  // --- INIT: hook su "Crea Files" ---
  function initValidazioneUlteriori() {
    const badge = document.getElementById('validazione_ulteriori_dichiarazioni');
    if (badge) badge.innerHTML = '';

    document.querySelectorAll('.crea-files').forEach(btn => {
      btn.addEventListener('click', (e) => {
        const ok = validaSezioneUlterioriDichiarazioni();
        if (!ok) {
          e.preventDefault();
          const collapse = document.getElementById('collapseNine');
          if (collapse && !collapse.classList.contains('show') && window.bootstrap?.Collapse) {
            new bootstrap.Collapse(collapse, { toggle: true });
          }
          document.getElementById('ulteriori-dichiarazioni')
            ?.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
      });
    });
  }

  // Esponi se serve altrove
  window.ValidationUlteriori = {
    validate: validaSezioneUlterioriDichiarazioni,
    init: initValidazioneUlteriori
  };

  document.addEventListener('DOMContentLoaded', initValidazioneUlteriori);
})();