$(document).on("click", "input[name=checkbox-policy]", function () {
  var valore = $(this).val();
  if (valore == 0) {
    $(this).val(1);
    $(this).removeClass("is-invalid");
    $("#errore_accettazione_privacy").removeClass("invalid-feedback");
    $("#errore_accettazione_privacy").text("");
    return;
  } else {
    $(this).val(0);
    $(this).addClass("is-invalid");
    $("#errore_accettazione_privacy").addClass("invalid-feedback");
    $("#errore_accettazione_privacy").text("Devi accettare obbligatoriamente la privacy policy.");
    return;
  }
});


/* validation/validazione_sezione_privacy.js */
(function () {
  'use strict';

  function paintHeader(sectionSelector, badgeSpanId, errorCount) {
    const headerBtn = document.querySelector(`${sectionSelector} .accordion-button`);
    const badgeSpan = document.getElementById(badgeSpanId);
    if (!headerBtn || !badgeSpan) return;

    // reset classi
    headerBtn.classList.remove(
      'bg-danger', 'bg-success', 'text-white',
      'background-color-success-accordion', 'background-color-error-accordion'
    );
    badgeSpan.classList.remove('badge', 'text-bg-success', 'text-bg-error');
    badgeSpan.classList.add('badge');

    if (errorCount > 0) {
      headerBtn.classList.add('background-color-error-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-error');
      badgeSpan.textContent = `Vi ${errorCount === 1 ? 'è' : 'sono'} ${errorCount} ${errorCount === 1 ? 'errore' : 'errori'}`;
    } else {
      headerBtn.classList.add('background-color-success-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-success');
      badgeSpan.textContent = 'Sezione Compilata Correttamente';
    }
  }

  function validaSezionePrivacy() {
    const section = document.getElementById('privacy-policy');
    if (!section) return true;

    let errorCount = 0;
    const chk = section.querySelector('#checkbox-policy');
    const err = document.getElementById('errore_accettazione_privacy');

    if (!chk || chk.disabled) return true;

    if (!chk.checked) {
      errorCount++;
      chk.classList.add('is-invalid');
      chk.classList.remove('is-valid');
      if (err) err.innerHTML = '<small class="text-danger">Devi accettare la privacy.</small>';
    } else {
      chk.classList.remove('is-invalid');
      chk.classList.add('is-valid');
      if (err) err.textContent = '';
    }

    paintHeader('#privacy-policy', 'validazione_sezione_privacy_policy', errorCount);
    return errorCount === 0;
  }

  function initValidazionePrivacy() {
    const badge = document.getElementById('validazione_sezione_privacy_policy');
    if (badge) badge.innerHTML = '';

    document.querySelectorAll('.crea-files').forEach(btn => {
      btn.addEventListener('click', (e) => {
        const ok = validaSezionePrivacy();
        if (!ok) {
          e.preventDefault();
          const collapse = document.getElementById('collapseTen');
          if (collapse && !collapse.classList.contains('show') && window.bootstrap?.Collapse) {
            new bootstrap.Collapse(collapse, { toggle: true });
          }
          document.getElementById('privacy-policy')
            ?.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
      });
    });
  }

  window.ValidationPrivacy = {
    validate: validaSezionePrivacy,
    init: initValidazionePrivacy
  };

  document.addEventListener('DOMContentLoaded', initValidazionePrivacy);
})();