/*
OnLoad form:
  - triggera evento di switch per confermare tipologia richiesta di default
  - triggera evento di switch per confermare tipologia beneficiario di default
*/
$(document).ready(function() {
    write_radio(document.getElementsByName("tipo_richiesta"), "impegno");
    switch_richiesta();
});

$(document).ready(function() {
    // 1) imposto di default il beneficiario A
    write_radio(document.getElementsByName("tipo_beneficiario"), "a");

    // 2) aggiorno header allegati (pubblico/privato)
    switch_beneficiario();

    // 3) FORZO anche l'aggiornamento della forma giuridica
    $('input[name="tipo_beneficiario"]:checked').trigger('change');
});

$(document).ready(function() {
    $("#contributo_ammesso").prop("disabled", true);
});

/*
OnChange radio button tipologia richiesta:
  - modifica sezioni
*/
$(document).on("change", "#richiesta", async function(event) {
    switch_richiesta();
});

/*
OnChange radio button tipologia beneficiario:
  - modifica lista forma giuridica
*/
$(document).on("change", "#beneficiario", async function(event) {
    switch_beneficiario();
});

/*
OnChange importo aggregato:
  - inserisce input file
*/
$('#investimenti').on('change', 'input[name="check_aggregato"]', function() {
    insert_input_prospetto($(this));
});

function write_radio(radioButtons, value) {
    for (const radio of radioButtons) {
        radio.checked = false;
        if (radio.value === value) {
          radio.checked = true;
          break;
        }
    }
}

function switch_richiesta() {
    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val();
    $("#accordionExample").hide();
    $("#impegno").hide();
    $("#liquidazione").hide();
    $("#ulteriori-dichiarazioni-impegno").hide();
    $("#ulteriori-dichiarazioni-rendicontazione").hide();
    if (tipo_richiesta === "impegno") {
        $("#accordionExample").show();
        $("#impegno").show();
        $("#ulteriori-dichiarazioni-impegno").show();
    } else if (tipo_richiesta === "liquidazione") {
        $("#accordionExample").show();
        $("#liquidazione").show();
        $("#ulteriori-dichiarazioni-rendicontazione").show();
    }
}

function getTipoBeneficiario() {
    const ben = $('input[name=tipo_beneficiario]:checked').val() || '';
    // ben è 'a', 'b', 'c', 'd', 'e', 'f', 'g'
  
    if (!ben) return '';
  
    // A, B, C -> COMUNI PUBBLICI
    if (['a', 'b', 'c'].includes(ben)) {
      return 'comuni';
    }
  
    // D, E, F, G -> ASSOCIAZIONI / PRIVATI
    if (['d', 'e', 'f', 'g'].includes(ben)) {
      return 'associazioni';
    }
  
    return '';
  }
function switch_beneficiario() {
    const tipo = getTipoBeneficiario(); 

    // Nascondo tutto
    $("#pubblico").hide();
    $("#privato").hide();
    $("#allegati_impegno_enti_non_pubblici").hide();

    // Mostro in base al tipo
    if (tipo === "comuni") {
        $("#pubblico").show();                 // tabella investimenti pubblici
        // allegati impegno: solo i 4 base (blocchetto privati nascosto)
    } 
    else if (tipo === "associazioni") {
        $("#privato").show();                  // tabella investimenti privati
        $("#allegati_impegno_enti_non_pubblici").show(); // allegati extra per privati
    }
}

function insert_input_prospetto(el) {
    const tipo = getTipoBeneficiario(); // 'comuni' | 'associazioni'

    const tr_investimenti = el.closest('tr');
    const id_riga_investimenti = tr_investimenti.attr('id');
    const id_riga_allegati = id_riga_investimenti.replace('oggetto_spesa_', '');

    const tr_allegati = $('#allegati_investimenti tbody').find('tr#' + id_riga_allegati);
    let td_prospetto = tipo === "comuni" ? tr_allegati.find('td').eq(5) : tr_allegati.find('td').eq(3);

    if (el.is(':checked')) {
        td_prospetto.html('<input type="file" class="form-control" name="prospetto_riparto" accept=".pdf, .doc, .docx, .xls, .xlsx"><div class="errore_prospetto_riporto"></div>');
    } else {
        td_prospetto.html('<span>NON RICHIESTO</span>');
    }
}