

function extract_data_by_key(rows, keys) {
    return keys.map(key => {
        return rows.map(riga => {
            const obj = riga[0];
            return obj?.[key] ?? '';
        });
    });
}

function setOtherData(sheet, sezione, columnHeader, rows, keys) {
    const data_by_field = extract_data_by_key(rows, keys);

    if (sezione !== '') {
        const rowIndex = sheet.rowCount + 1;
        sheet.mergeCells(`A${rowIndex}:B${rowIndex}`);
        const cell = sheet.getCell(rowIndex, 1);
        cell.value = sezione;
        cell.alignment = { horizontal: 'center', vertical: 'middle' };
        cell.font = { bold: true, size: 11 };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    }

    columnHeader.forEach((fieldLabel, index) => {
        const row = sheet.addRow([fieldLabel, ...data_by_field[index]]);

        row.getCell(1).font = { bold: true };
        row.eachCell((cell, i) => {
            cell.alignment = { wrapText: true, vertical: 'middle' };
            if (cell.value !== '') {
                cell.border = {
                    top: { style: 'thin' },
                    left: { style: 'thin' },
                    bottom: { style: 'thin' },
                    right: { style: 'thin' }
                };
            }
        });
    });
}

function getFormattedDate(date) {
    var date = date.split("-");
    var anno = date[0];
    var mese = date[1];
    var giorno = date[2];

    return giorno + '/' + mese + '/' + anno;
}


function tipoBeneficiarioE() {
    const ben = $('input[name=tipo_beneficiario]:checked').val() || '';
    // ben è 'a', 'b', 'c', 'd', 'e', 'f', 'g'

    if (!ben) return '';

    // A, B, C -> COMUNI PUBBLICI
    if (['a', 'b', 'c'].includes(ben)) {
        return 'comuni';
    }

    // D, E, F, G -> ASSOCIAZIONI / PRIVATI
    if (['d', 'e', 'f', 'g'].includes(ben)) {
        return 'associazioni';
    }

    return '';
}
function crea_dati_excel() {
    const versione = $("#versione").val();
    const cuaa = $(`#cuaa_beneficiario`).val();
    const tipo_richiesta = $('input[name=tipo_richiesta]:checked').val();
    const tipo_beneficiario = tipoBeneficiarioE();
    const outputPath = `${cuaa}_Checklist_` + versione + `.xlsx`;
    const data = {
        anagrafica: {},
        iniziativa: {},
        rendicontazione: {},
        allegati: {},
        rpa: {}
    };

    // ANAGRAFICA
    data.anagrafica.nome_rappr = $(`#nome_rappr`).val();
    data.anagrafica.cognome_rappr = $(`#cognome_rappr`).val();
    data.anagrafica.cf_rappr = $(`#cf_rappresentante`).val();   // <— NUOVO
    data.anagrafica.ddn_rappr = getFormattedDate($(`#data_nascita_rappr`).val());
    data.anagrafica.ldn_rappr = $(`#luogo_nascita_rappr`).val();
    data.anagrafica.pdn_rappr = $(`#provincia_nascita_rappr`).val();
    data.anagrafica.residenza_rappr = $(`#residenza_rappr`).val();
    data.anagrafica.provincia_rappr = $(`#provincia_rappr`).val();
    data.anagrafica.indirizzo_rappr = $(`#indirizzo_rappr`).val();
    data.anagrafica.civico_rappr = $(`#civico_rappr`).val();
    data.anagrafica.telefono_rappr = $(`#telefono_rappr`).val();
    const ben = $('input[name=tipo_beneficiario]:checked').val();  // a b c d e f g
    data.anagrafica.forma_giuridica = $(`#forma_giuridica_${ben} option:selected`).text().trim();
    data.anagrafica.denominazione = $(`#denominazione_beneficiario`).val();
    data.anagrafica.cuaa = cuaa;
    data.anagrafica.sede_legale = $(`#sede_beneficiario`).val();
    data.anagrafica.provincia_sede_legale = $(`#sede_provincia_beneficiario`).val();
    data.anagrafica.indirizzo_sede_legale = $(`#sede_indirizzo_beneficiario`).val();
    data.anagrafica.civico_sede_legale = $(`#civico_sede_beneficiario`).val();
    data.anagrafica.email = $(`#email_beneficiario`).val();
    data.anagrafica.pec = $(`#pec_beneficiario`).val();
    data.anagrafica.telefono = $(`#telefono_beneficiario`).val();

    // INIZIATIVA
    data.iniziativa.titolo = $(`#titolo_iniziativa`).val();
    data.iniziativa.inizio = getFormattedDate($(`#data_inizio`).val());
    data.iniziativa.fine = getFormattedDate($(`#data_fine`).val());
    data.iniziativa.provincia = $(`#sede_provincia_iniziativa`).val();
    data.iniziativa.luogo = $(`#sede_iniziativa`).val();
    data.iniziativa.descrizione = $(`#descrizione_iniziativa`).val();

    if (tipo_richiesta === "impegno") {
        data.iniziativa.linea = $(`#selezione_tipo_linea`).val();
        data.iniziativa.contributo = $(`#contributo_ammesso`).val();
    } else if (tipo_richiesta === "liquidazione") {
        data.rendicontazione.iban = $(`#iban`).val();
        data.rendicontazione.istituto = $(`#istituto-credito`).val();
        data.rendicontazione.agenzia = $(`#agenzia_banca`).val();
        // 🔽 NUOVI CAMPI DRS
        data.rendicontazione.numero_drs = $('#numeroDRS').val();
        data.rendicontazione.data_drs = getFormattedDate($('#dataDRS').val());
        data.rendicontazione.importo_drs = $('#importoAmmissibile').val();
    }



    return genera_excel(outputPath, tipo_richiesta, tipo_beneficiario, data);
}

async function genera_excel(outputPath, tipo_richiesta, tipo_beneficiario, data) {
    const workbook = new ExcelJS.Workbook();
    switch (tipo_richiesta) {
        case "impegno":
            genera_sheet_anagrafica(workbook, data.anagrafica);
            genera_sheet_iniziativa(workbook, data.iniziativa);
            genera_sheet_allegati(workbook, tipo_beneficiario, tipo_richiesta);
            genera_sheet_rpa(workbook, data, 'impegno');
            break;
        case "liquidazione":
            genera_sheet_anagrafica(workbook, data.anagrafica);
            genera_sheet_iniziativa(workbook, data.iniziativa);
            genera_sheet_rendicontazione(workbook, tipo_beneficiario, data.rendicontazione);
            genera_sheet_allegati(workbook, tipo_beneficiario, tipo_richiesta);
            genera_sheet_rpa(workbook, data, 'liquidazione');
            break;
    }
    const buffer = await workbook.xlsx.writeBuffer();
    const fileBlob = new Blob([buffer], { type: 'application/vnd.openxmlformats-officedocument.spreadsheetml.sheet' });
    return { blob: fileBlob, nomeFile: outputPath };

}

async function genera_sheet_anagrafica(workbook, data) {
    const sheet_anagrafica = workbook.addWorksheet('Anagrafica');
    const imageId = workbook.addImage({
        base64: $('#png_regione_siciliana').attr('src').split(',')[1],
        extension: 'png'
    });
    sheet_anagrafica.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });
    sheet_anagrafica.mergeCells('A1:G4');
    sheet_anagrafica.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet_anagrafica.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_anagrafica.getCell('A1').font = { bold: true, size: 14 };
    sheet_anagrafica.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet_anagrafica.mergeCells('A5:G12');
    sheet_anagrafica.getCell('A5').value = 'Iniziative di promozione e valorizzazione dei prodotti agricoli e agroalimentari.';
    sheet_anagrafica.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_anagrafica.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
    sheet_anagrafica.getCell('A5').font = { size: 14 };

    sheet_anagrafica.mergeCells('A13:G16');
    sheet_anagrafica.getCell('A13').value = 'Proposta progettuale per la valorizzazione dei prodotti agricoli identitari ';
    sheet_anagrafica.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet_anagrafica.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet_anagrafica.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet_anagrafica.columns = [
        { key: 'colA', width: 45.97 },
        { key: 'colB', width: 10.39 },
        { key: 'colC', width: 14.91 },
        { key: 'colD', width: 16.55 },
        { key: 'colE', width: 11.26 },
        { key: 'colF', width: 9.00 },
    ];

    const anagrafica_rappr_header = [
        'Nome', 'Cognome', 'Codice Fiscale', 'Data di nascita', 'Luogo di nascita', 'Provincia di nascita',
        'Residenza', 'Provincia', 'Indirizzo', 'Civico', 'Telefono'
    ];
    const anagrafica_rappr_keys = [
        'nome_rappr', 'cognome_rappr', 'cf_rappr', 'ddn_rappr', 'ldn_rappr', 'pdn_rappr',
        'residenza_rappr', 'provincia_rappr', 'indirizzo_rappr', 'civico_rappr', 'telefono_rappr'
    ];
    setOtherData(sheet_anagrafica, 'Anagrafica Rappresentante Legale', anagrafica_rappr_header, [[data]], anagrafica_rappr_keys);
    const anagrafica_proponente_header = [
        'Forma Giuridica', 'Denominazione', 'CUAA', 'Sede Legale', 'Provincia',
        'Indirizzo', 'Civico', 'Email', 'PEC', 'Telefono'
    ];
    const anagrafica_proponente_keys = [
        'forma_giuridica', 'denominazione', 'cuaa', 'sede_legale', 'provincia_sede_legale',
        'indirizzo_sede_legale', 'civico_sede_legale', 'email', 'pec', 'telefono'
    ];
    setOtherData(sheet_anagrafica, 'Anagrafica Soggetto Proponente', anagrafica_proponente_header, [[data]], anagrafica_proponente_keys);
}

async function genera_sheet_iniziativa(workbook, data) {
    const sheet_iniziativa = workbook.addWorksheet('Iniziativa');
    const imageId = workbook.addImage({
        base64: $('#png_regione_siciliana').attr('src').split(',')[1],
        extension: 'png'
    });
    sheet_iniziativa.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });
    sheet_iniziativa.mergeCells('A1:G4');
    sheet_iniziativa.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet_iniziativa.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_iniziativa.getCell('A1').font = { bold: true, size: 14 };
    sheet_iniziativa.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet_iniziativa.mergeCells('A5:G12');
    sheet_iniziativa.getCell('A5').value = 'Iniziative di promozione e valorizzazione dei prodotti agricoli e agroalimentari.';
    sheet_iniziativa.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_iniziativa.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
    sheet_iniziativa.getCell('A5').font = { size: 14 };

    sheet_iniziativa.mergeCells('A13:G16');
    sheet_iniziativa.getCell('A13').value = 'Proposta progettuale per la valorizzazione dei prodotti agricoli identitari ';
    sheet_iniziativa.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet_iniziativa.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet_iniziativa.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet_iniziativa.columns = [
        { key: 'colA', width: 45.97 },
        { key: 'colB', width: 10.39 },
        { key: 'colC', width: 14.91 },
        { key: 'colD', width: 16.55 },
        { key: 'colE', width: 11.26 },
        { key: 'colF', width: 9.00 },
    ];

    const iniziativa_header = [
        'Titolo', 'Data inizio', 'Data fine', 'Provincia', 'Luogo',
        'Descrizione', 'Tipo linea', 'Contributo massimo'
    ];
    const iniziativa_keys = [
        'titolo', 'inizio', 'fine', 'provincia', 'luogo',
        'descrizione', 'linea', 'contributo'
    ];
    setOtherData(sheet_iniziativa, 'Iniziativa', iniziativa_header, [[data]], iniziativa_keys);
    // 🔽 AGGIUNGERE SUBITO DOPO setOtherData(...)

}

async function genera_sheet_rendicontazione(workbook, tipo_beneficiario, bank_data) {
    function insertAndShift(riga, arr, row_index, index, value) {
        if (riga.find(`td:eq(${row_index}) input`).attr('type') !== 'file') {
            arr.splice(index, 0, value);
            return arr[index];
        }
    }
    const righe_tabella = $("#investimenti tbody tr");
    const righe_allegati = $("#allegati_investimenti tbody tr");
    const righe_spese = [];
    const sheet_rendicontazione = workbook.addWorksheet('Rendicontazione');
    const imageId = workbook.addImage({
        base64: $('#png_regione_siciliana').attr('src').split(',')[1],
        extension: 'png'
    });
    sheet_rendicontazione.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });
    sheet_rendicontazione.columns = tipo_beneficiario === "comuni" ?
        [
            { key: 'oggetto', width: 50 },
            { key: 'data', width: 10 },
            { key: 'beneficiario', width: 20 },
            { key: 'cuaa', width: 20 },
            { key: 'importo', width: 20 },
            { key: 'n_fatt', width: 20 },
            { key: 'delibera_affidamento', width: 20 },
            { key: 'delibera_pagamento', width: 20 },
            { key: 'mandato_pagamento', width: 20 },
            { key: 'fattura', width: 20 },
            { key: 'prospetto', width: 20 },
            { key: 'importo_liquidabile', width: 20 },      // NEW
            { key: 'importo_non_liquidabile', width: 20 },  // NEW
            { key: 'note', width: 10 },
        ] :
        [
            { key: 'oggetto', width: 50 },
            { key: 'data', width: 10 },
            { key: 'beneficiario', width: 20 },
            { key: 'cuaa', width: 20 },
            { key: 'importo', width: 20 },
            { key: 'n_fatt', width: 20 },
            { key: 'fattura', width: 20 },
            { key: 'ricevuta_bonifico_assegno', width: 20 },
            { key: 'prospetto', width: 20 },
            { key: 'importo_liquidabile', width: 20 },      // NEW
            { key: 'importo_non_liquidabile', width: 20 },  // NEW
            { key: 'note', width: 10 },
        ];
    sheet_rendicontazione.mergeCells('A1:G4');
    sheet_rendicontazione.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet_rendicontazione.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_rendicontazione.getCell('A1').font = { bold: true, size: 14 };
    sheet_rendicontazione.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet_rendicontazione.mergeCells('A5:G12');
    sheet_rendicontazione.getCell('A5').value = 'Iniziative di promozione e valorizzazione dei prodotti agricoli e agroalimentari.';
    sheet_rendicontazione.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_rendicontazione.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
    sheet_rendicontazione.getCell('A5').font = { size: 14 };

    sheet_rendicontazione.mergeCells('A13:G16');
    sheet_rendicontazione.getCell('A13').value = 'Proposta progettuale per la valorizzazione dei prodotti agricoli identitari ';
    sheet_rendicontazione.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet_rendicontazione.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet_rendicontazione.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };
    tipo_beneficiario === "comuni" ?
        sheet_rendicontazione.addRow([
            "OGGETTO DELLA SPESA",
            "DATA PAGAMENTO",
            "BENEFICIARIO",
            "CF/P.IVA",
            "IMPORTO",
            "FATTURA N°/TITOLO",
            "DELIBERA AFFIDAMENTO",
            "DELIBERA PAGAMENTO",
            "MANDATO PAGAMENTO",
            "FATTURA",
            "PROSPETTO DI RIPARTO",
            "IMPORTO LIQUIDABILE",        // NEW
            "IMPORTO NON LIQUIDABILE",    // NEW
            "NOTE"
        ]) :
        sheet_rendicontazione.addRow([
            "OGGETTO DELLA SPESA",
            "DATA PAGAMENTO",
            "BENEFICIARIO",
            "CF/P.IVA",
            "IMPORTO",
            "FATTURA N°/TITOLO",
            "FATTURA",
            "RICEVUTA BONIFICO O\nASSEGNO CON ESTRATTO CONTO",
            "PROSPETTO RIPARTO",
            "IMPORTO LIQUIDABILE",        // NEW
            "IMPORTO NON LIQUIDABILE",    // NEW
            "NOTE"
        ]);

    var headerRow = sheet_rendicontazione.getRow(sheet_rendicontazione.rowCount);
    headerRow.height = 42;
    headerRow.eachCell((cell, colNumber) => {
        cell.alignment = {
            horizontal: 'center',
            vertical: 'middle',
            wrapText: true
        };
        cell.font = { bold: true };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
        sheet_rendicontazione.getColumn(colNumber).width = sheet_rendicontazione.columns[colNumber - 1].width;
    });
    headerRow.commit();

    // PRIMA del loop:
    let j = -1; // indice SOLO per le righe "oggetto_spesa_*"

    righe_tabella.each(function () {
        const id = $(this).attr("id");

        if (id && id.indexOf("oggetto_spesa_") === 0) {
            j++; // avanza solo sulle righe spesa reali
            const riga_allegati = righe_allegati.eq(j); // riga allegati "gemella"

            const oggetto = $(this).find("td:eq(0) input").val();
            const data = getFormattedDate($(this).find("td:eq(1) input").val());
            const beneficiario = $(this).find("td:eq(2) input").val();
            const cuaa = $(this).find("td:eq(3) input").val();
            const importo = $(this).find("td:eq(4) input").val();
            const n_fattura = $(this).find("td:eq(5) input").val();

            const tab = [oggetto, data, beneficiario, cuaa, importo, n_fattura];

            if (tipo_beneficiario === "comuni") {
                // il "prospetto" è in colonna 5 della tabella allegati dei COMUNI
                const cellProsp = riga_allegati.find("td:eq(5)");
                const isFile = cellProsp.find("input[type='file']").length > 0;
                const prosp = isFile
                    ? (file_names.prospetto_riparto?.[j] || "")
                    : (cellProsp.find("span").text().trim() || "");

                tab.push(
                    file_names.delibera_affidamento?.[j] || "",
                    file_names.delibera_pagamento?.[j] || "",
                    file_names.mandato_pagamento?.[j] || "",
                    file_names.fattura?.[j] || "",
                    prosp,
                    "", // IMPORTO LIQUIDATO
                    "", // IMPORTO NON LIQUIDATO
                    ""  // NOTE
                );
            } else {
                // ASSOCIAZIONI: il "prospetto" è in colonna 3 della tabella allegati
                const cellProsp = riga_allegati.find("td:eq(3)");
                const isFile = cellProsp.find("input[type='file']").length > 0;
                const prosp = isFile
                    ? (file_names.prospetto_riparto?.[j] || "")
                    : (cellProsp.find("span").text().trim() || "");

                tab.push(
                    file_names.fattura?.[j] || "",
                    file_names.ricevuta_bonifico_assegno?.[j] || "",
                    prosp,
                    "", // IMPORTO LIQUIDATO
                    "", // IMPORTO NON LIQUIDATO
                    ""  // NOTE
                );
            }

            righe_spese.push({ tab1: tab });
        }

        if (id === "totale_spdi") {
            const importo_totale = $("#importo_totale").attr("valore");
            if (tipo_beneficiario === "comuni") {
                righe_spese.push({
                    tab1: [
                        "Totale", "", "", "", importo_totale, "",
                        "", "", "", "", // delibere/mandato/fattura
                        "",          // prospetto
                        "", "",      // importo_liquidato, importo_non_liquidato
                        ""           // note
                    ]
                });
            } else {
                righe_spese.push({
                    tab1: [
                        "Totale", "", "", "", importo_totale, "",
                        "", "",      // fattura, ricevuta
                        "",         // prospetto
                        "", "",     // importi
                        ""          // note
                    ]
                });
            }
        }
    });

    const rendicontazione_data = righe_spese.map(riga => riga.tab1);

    rendicontazione_data.forEach(el => {
        const row = sheet_rendicontazione.addRow(el);
        row.height = 52;
        row.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
        if (el[0] === "Totale") {
            row.getCell(1).font = { bold: true };
        }
    });

    sheet_rendicontazione.eachRow((row) => {
        row.eachCell((cell) => {
            cell.border = {
                top: { style: 'thin' },
                left: { style: 'thin' },
                bottom: { style: 'thin' },
                right: { style: 'thin' }
            };
        });
    });


    sheet_rendicontazione.addRow([]);
    sheet_rendicontazione.addRow([]);

    const banca_header = [
        'IBAN', 'Istituto di Credito', 'Agenzia'
    ];
    const banca_keys = [
        'iban', 'istituto', 'agenzia'
    ];
    setOtherData(sheet_rendicontazione, 'Dati Bancari', banca_header, [[bank_data]], banca_keys);
    // 🔽 NUOVA SEZIONE: Rendicontazione delle Spese (DRS)
    const drs_header = [
        'Contributo concesso con DRS',
        'Numero DRS',
        'Data DRS'
    ];
    const drs_keys = [
        'importo_drs',
        'numero_drs',
        'data_drs'
    ];
    setOtherData(
        sheet_rendicontazione,
        'Sezione Rendicontazione delle Spese',
        drs_header,
        [[bank_data]],
        drs_keys
    );
}

async function genera_sheet_allegati(workbook, tipo_beneficiario, tipo_richiesta) {
    const sheet_allegati = workbook.addWorksheet('Allegati');
    const imageId = workbook.addImage({
        base64: $('#png_regione_siciliana').attr('src').split(',')[1],
        extension: 'png'
    });
    sheet_allegati.addImage(imageId, {
        tl: { col: 0, row: 0 },
        ext: { width: 60, height: 60 }
    });
    sheet_allegati.columns =
        [
            { key: 'descrizione', width: 50 },
            { key: 'file', width: 20 },
            { key: 'note', width: 10 },
        ]
    sheet_allegati.mergeCells('A1:G4');
    sheet_allegati.getCell('A1').value = 'Assessorato dell’agricoltura, dello sviluppo rurale e della pesca mediterranea\nDipartimento dell’agricoltura';
    sheet_allegati.getCell('A1').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_allegati.getCell('A1').font = { bold: true, size: 14 };
    sheet_allegati.getCell('A1').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'FFFFFF' } };

    sheet_allegati.mergeCells('A5:G12');
    sheet_allegati.getCell('A5').value = 'Iniziative di promozione e valorizzazione dei prodotti agricoli e agroalimentari.';
    sheet_allegati.getCell('A5').alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    sheet_allegati.getCell('A5').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'D9D9D9' } };
    sheet_allegati.getCell('A5').font = { size: 14 };

    sheet_allegati.mergeCells('A13:G16');
    sheet_allegati.getCell('A13').value = 'Proposta progettuale per la valorizzazione dei prodotti agricoli identitari ';
    sheet_allegati.getCell('A13').alignment = { horizontal: 'center', vertical: 'middle' };
    sheet_allegati.getCell('A13').font = { bold: true, size: 14, color: { argb: 'FFFFFF' } };
    sheet_allegati.getCell('A13').fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: '002060' } };

    sheet_allegati.addRow([
        "DESCRIZIONE",
        "FILE",
        "NOTE"
    ]);

    var headerRow = sheet_allegati.getRow(sheet_allegati.rowCount);
    headerRow.height = 42;
    headerRow.eachCell((cell, colNumber) => {
        cell.alignment = {
            horizontal: 'center',
            vertical: 'middle',
            wrapText: true
        };
        cell.font = { bold: true };
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
        sheet_allegati.getColumn(colNumber).width = sheet_allegati.columns[colNumber - 1].width;
    });
    headerRow.commit();

    const righe = [];
    const descrizioni = [
        "Copia del progetto dettagliato con relazione illustrativa e date previste.",
        "Copia del piano economico con indicazione dei costi unitari, totali e fonti di finanziamento.",
        "Copia documento di identità del legale rappresentante.",
        "Copia della dichiarazione di adesione agli impegni \"Regione europea della gastronomia\"",
        "Copia della dichiarazione autocertificata del legale rappresentante del soggetto proponente dal quale risultano la denominazione e iscrizione ai registri camerali, cariche sociali e loro durata, poteri di rappresentanza e/o di firma, partita I.V.A. e/o codice fiscale, con allegata la dichiarazione, appositamente sottoscritta, che l’impresa non è stata dichiarata fallita, che non ha procedure concorsuali in corso o si trova in amministrazione controllata.",
        "Copia dello statuto dei soggetti privati proponenti.",
        "Copia della dichiarazione sostitutiva di certificazione antimafia.",
        "Copia dei curricula del/dei soggetto/i.",
        "DURC in corso di validità (oppure, in assenza di obblighi previdenziali, idonea dichiarazione di non essere soggetto all’obbligo).",
        "Copia della relazione finale.",
        "Copia della documentazione multimediale/pubblicitaria.",
        "Copia della dichiarazione ai sensi del DPR 445/2000 e ss.mm.ii., di non aver beneficiato di altri contributi per le spese sostenute per l'acquisto di beni e servizi oggetto del contributo concesso e destinati alla stessa manifestazione.",
        "Dettagliata motivazione di eventuali scostamenti rispetto al preventivo approvato in sede di concessione del contributo.",
        "Documentazione fotografica.",
        "Link a documentazione video.",
    ];
    const tipo_beneficiario_sel = tipoBeneficiarioE();
    const formaTxt = $(`#forma_giuridica_${tipo_beneficiario_sel} option:selected`).text().trim();
    // match più elastico: “Comune …”, “Unione di Comuni”, ecc.
    const isComune = /\bcomune\b/i.test(formaTxt);
    if (isComune) {
        righe.push({ tab1: ["Delega del Sindaco", (file_names.allegato_delega_sindaco?.[0] || ""), ""] });
    }
    righe.push({ tab1: [descrizioni[0], file_names.allegato_progetto[0], ""] });
    if (tipo_richiesta === "impegno") {
        righe.push({ tab1: [descrizioni[1], file_names.allegato_piano_economico[0], ""] });
        righe.push({
            tab1: [
                "Progetto dettagliato dell’iniziativa (come previsto dall'Allegato 1 del D.A. n. 54/GAB)",
                file_names.allegato_progetto2?.[0] || "",
                ""
            ]
        });
        righe.push({ tab1: [descrizioni[2], file_names.allegato_documento_identita[0], ""] });
        righe.push({ tab1: [descrizioni[3], file_names.allegato_gastronomia[0], ""] });
        if (tipo_beneficiario === "associazioni") {
            righe.push({ tab1: [descrizioni[4], file_names.allegato_autocertificazione[0], ""] });
            righe.push({ tab1: [descrizioni[5], file_names.allegato_statuto[0], ""] });
            righe.push({ tab1: [descrizioni[6], file_names.allegato_antimafia[0], ""] });
            righe.push({ tab1: [descrizioni[7], file_names.allegato_curricula[0], ""] });
            righe.push({ tab1: [descrizioni[8], file_names.allegato_DURC[0], ""] });
        }
    } else if (tipo_richiesta === "liquidazione") {
        righe.push({ tab1: [descrizioni[9], file_names.allegato_relazione[0], ""] });
        righe.push({ tab1: [descrizioni[10], file_names.allegato_documentazione_pubblicitaria[0], ""] });
        righe.push({ tab1: [descrizioni[11], file_names.allegato_dichiarazione_no_contributi[0], ""] });
        righe.push({ tab1: [descrizioni[12], file_names.allegato_scostamenti[0], ""] });
        righe.push({ tab1: [descrizioni[13], file_names.allegato_foto[0], ""] });
        righe.push({ tab1: [descrizioni[14], $("#allegato_link_video").val(), ""] });
    }

    const allegati_data = righe.map(riga => riga.tab1);
    allegati_data.forEach(el => {
        const row = sheet_allegati.addRow(el);
        row.height = 52;
        row.alignment = { horizontal: 'center', vertical: 'middle', wrapText: true };
    });

    sheet_allegati.eachRow((row) => {
        row.eachCell((cell) => {
            cell.border = {
                top: { style: 'thin' },
                left: { style: 'thin' },
                bottom: { style: 'thin' },
                right: { style: 'thin' }
            };
        });
    });
}
async function genera_sheet_rpa(workbook, data, tipo_richiesta) {
    const sheet = workbook.addWorksheet('INPUT RPA');

    if (tipo_richiesta === 'liquidazione') {
        // ===== RENDICONTAZIONE =====
        // Colonne: BENEFICIARIO | CODICE FISCALE | CUAA | TOTALE SPESA | TITOLO | LUOGO | PROVINCIA | DATA INIZIO | DATA FINE | IBAN
        const headers = [
            'BENEFICIARIO',
            'CODICE FISCALE',
            'CUAA',
            'TOTALE SPESA',
            'TITOLO INIZIATIVA',
            'LUOGO',
            'PROVINCIA',
            'DATA INIZIO',
            'DATA FINE',
            'IBAN',
            'IMPORTO CONCESSO',
            'NUMERO DECRETO',
            'DATA DECRETO'
        ];
        sheet.addRow(headers);

        const rowFormulas = [
            // BENEFICIARIO = Denominazione soggetto proponente (foglio Anagrafica)
            { formula: 'INDEX(Anagrafica!B:B, MATCH("Denominazione", Anagrafica!A:A, 0))' },
            // CODICE FISCALE = CF del rappresentante legale
            { formula: 'INDEX(Anagrafica!B:B, MATCH("Codice Fiscale", Anagrafica!A:A, 0))' },
            // CUAA
            { formula: 'INDEX(Anagrafica!B:B, MATCH("CUAA", Anagrafica!A:A, 0))' },
            // TOTALE SPESA = somma importi rendicontazione (esclusa riga Totale)
            { formula: 'SUMPRODUCT((Rendicontazione!A18:A1000<>"Totale")*--Rendicontazione!E18:E1000)' },
            { formula: 'Iniziativa!B18' }, // TITOLO INIZIATIVA
            { formula: 'Iniziativa!B22' }, // LUOGO
            { formula: 'Iniziativa!B21' }, // PROVINCIA
            { formula: 'Iniziativa!B19' }, // DATA INIZIO
            { formula: 'Iniziativa!B20' }, // DATA FINE
            // IBAN preso dalla sezione "Dati Bancari" (Rendicontazione)
            { formula: 'INDEX(Rendicontazione!B:B, MATCH("IBAN", Rendicontazione!A:A, 0))' },
            // IMPORTO CONCESSO = "Contributo concesso con DRS" in Rendicontazione
            { formula: 'INDEX(Rendicontazione!B:B, MATCH("Contributo concesso con DRS", Rendicontazione!A:A, 0))' },
            // NUMERO DECRETO = "Numero DRS"
            { formula: 'INDEX(Rendicontazione!B:B, MATCH("Numero DRS", Rendicontazione!A:A, 0))' },
            // DATA DECRETO = "Data DRS"
            { formula: 'INDEX(Rendicontazione!B:B, MATCH("Data DRS", Rendicontazione!A:A, 0))' }
        ];
        sheet.addRow(rowFormulas);

        // larghezza colonne
        sheet.columns = [
            { width: 25 }, // BENEFICIARIO
            { width: 20 }, // CODICE FISCALE
            { width: 20 }, // CUAA
            { width: 18 }, // TOTALE SPESA
            { width: 35 }, // TITOLO
            { width: 18 }, // LUOGO
            { width: 12 }, // PROVINCIA
            { width: 14 }, // DATA INIZIO
            { width: 14 }, // DATA FINE
            { width: 28 }, // IBAN
            { width: 18 }, // IMPORTO CONCESSO
            { width: 18 }, // NUMERO DECRETO
            { width: 14 }  // DATA DECRETO
        ];

        // formati
        sheet.getColumn(4).numFmt = '#,##0.00';   // TOTALE SPESA
        sheet.getColumn(8).numFmt = 'dd/mm/yyyy'; // DATA INIZIO
        sheet.getColumn(9).numFmt = 'dd/mm/yyyy'; // DATA FINE
        sheet.getColumn(10).numFmt = '@';          // IBAN come testo
        sheet.getColumn(11).numFmt = '#,##0.00';   // IMPORTO CONCESSO
        sheet.getColumn(13).numFmt = 'dd/mm/yyyy'; // DATA DECRETO

    } else {
        // ===== ISTANZA (IMPEGNO) =====
        // Colonne: BENEFICIARIO | CODICE FISCALE | CUAA | TITOLO | LUOGO | PROVINCIA | DATA INIZIO | DATA FINE | MASSIMALE LINEA
        const headers = [
            'BENEFICIARIO',
            'CODICE FISCALE',
            'CUAA',
            'TITOLO INIZIATIVA',
            'LUOGO',
            'PROVINCIA',
            'DATA INIZIO',
            'DATA FINE',
            'MASSIMALE LINEA'
        ];
        sheet.addRow(headers);

        const rowFormulas = [
            // BENEFICIARIO = Denominazione soggetto proponente
            { formula: 'INDEX(Anagrafica!B:B, MATCH("Denominazione", Anagrafica!A:A, 0))' },
            // CODICE FISCALE = CF rappresentante legale
            { formula: 'INDEX(Anagrafica!B:B, MATCH("Codice Fiscale", Anagrafica!A:A, 0))' },
            // CUAA proponente
            { formula: 'INDEX(Anagrafica!B:B, MATCH("CUAA", Anagrafica!A:A, 0))' },
            { formula: 'Iniziativa!B18' }, // TITOLO INIZIATIVA
            { formula: 'Iniziativa!B22' }, // LUOGO
            { formula: 'Iniziativa!B21' }, // PROVINCIA
            { formula: 'Iniziativa!B19' }, // DATA INIZIO
            { formula: 'Iniziativa!B20' }, // DATA FINE
            { formula: 'Iniziativa!B25' }  // MASSIMALE LINEA
        ];
        sheet.addRow(rowFormulas);

        sheet.columns = [
            { width: 25 }, // BENEFICIARIO
            { width: 20 }, // CODICE FISCALE
            { width: 20 }, // CUAA
            { width: 35 }, // TITOLO
            { width: 18 }, // LUOGO
            { width: 12 }, // PROVINCIA
            { width: 14 }, // DATA INIZIO
            { width: 14 }, // DATA FINE
            { width: 18 }  // MASSIMALE
        ];

        sheet.getColumn(7).numFmt = 'dd/mm/yyyy'; // DATA INIZIO
        sheet.getColumn(8).numFmt = 'dd/mm/yyyy'; // DATA FINE
        sheet.getColumn(9).numFmt = '#,##0.00';   // MASSIMALE LINEA
    }

    // stile comune
    const headerRow = sheet.getRow(1);
    headerRow.font = { bold: true };
    headerRow.alignment = { horizontal: 'center', vertical: 'middle' };
    headerRow.eachCell((cell) => {
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });

    const dataRow = sheet.getRow(2);
    dataRow.alignment = { vertical: 'middle', wrapText: true };
    dataRow.eachCell((cell) => {
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });

    // 👉 QUI: dopo INPUT RPA, aggiungi il nuovo sheet solo per LIQUIDAZIONE
    if (tipo_richiesta === 'liquidazione') {
        genera_sheet_riepilogo_liquidazione(workbook);
    } else if (tipo_richiesta === 'impegno') {
        genera_sheet_riepilogo_istanza(workbook);
    }
}

function genera_sheet_riepilogo_liquidazione(workbook) {
    const sheet = workbook.addWorksheet('RIEPILOGO LIQUIDAZIONE');

    // intestazioni come nello screenshot
    const headers = [
        'PROT. N. DEL',
        'BENEFICIARIO',
        'CUAA',
        'TITOLO INIZIATIVA',
        'LUOGO',
        'PROVINCIA',
        'DATA INIZIO',
        'DATA FINE',
        'IMPORTO RICHIESTO',
        'CONTRIBUTO CONCESSO'
    ];
    sheet.addRow(headers);

    // QUI prendi il protocollo dalla tua pagina (adatta l'ID al tuo campo)
    const protocollo = ($('#protocollo_liquidazione').val() || '').trim();

    // Riga dati, quasi tutto arriva con formule dagli altri fogli
    const dataRow = [
        protocollo, // PROT. N. DEL - se vuoi puoi lasciarlo vuoto e compilarlo a mano
        { formula: 'INDEX(Anagrafica!B:B, MATCH("Denominazione", Anagrafica!A:A, 0))' },
        { formula: 'INDEX(Anagrafica!B:B, MATCH("CUAA", Anagrafica!A:A, 0))' },
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Titolo", Iniziativa!A:A, 0))' },
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Luogo", Iniziativa!A:A, 0))' },
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Provincia", Iniziativa!A:A, 0))' },
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Data inizio", Iniziativa!A:A, 0))' },
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Data fine", Iniziativa!A:A, 0))' },
        // IMPORTO RICHIESTO = totale spesa rendicontata
        { formula: 'SUMPRODUCT((Rendicontazione!A18:A1000<>"Totale")*--Rendicontazione!E18:E1000)' },
        { formula: 'INDEX(Rendicontazione!B:B, MATCH("Contributo concesso con DRS", Rendicontazione!A:A, 0))' }

    ];
    sheet.addRow(dataRow);

    // larghezze colonne
    sheet.columns = [
        { width: 20 }, // PROT. N. DEL
        { width: 30 }, // BENEFICIARIO
        { width: 18 }, // CUAA
        { width: 35 }, // TITOLO
        { width: 20 }, // LUOGO
        { width: 10 }, // PROVINCIA
        { width: 14 }, // DATA INIZIO
        { width: 14 }, // DATA FINE
        { width: 18 }, // IMPORTO RICHIESTO
        { width: 18 }  // CONTRIBUTo CONCESSO
    ];

    // formati
    sheet.getColumn(7).numFmt = 'dd/mm/yyyy'; // DATA INIZIO
    sheet.getColumn(8).numFmt = 'dd/mm/yyyy'; // DATA FINE
    sheet.getColumn(9).numFmt = '#,##0.00';   // IMPORTO RICHIESTO
    sheet.getColumn(10).numFmt = '#,##0.00';  // CONTRIBUTO CONCESSO
    // stile header
    const headerRow = sheet.getRow(1);
    headerRow.font = { bold: true };
    headerRow.alignment = { horizontal: 'center', vertical: 'middle' };
    headerRow.eachCell((cell) => {
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });

    const row2 = sheet.getRow(2);
    row2.alignment = { vertical: 'middle', wrapText: true };
    row2.eachCell((cell) => {
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });
}


function genera_sheet_riepilogo_istanza(workbook) {
    const sheet = workbook.addWorksheet('RIEPILOGO ISTANZA');

    // intestazioni come nello screenshot
    const headers = [
        'PROT. N. DEL',
        'BENEFICIARIO',
        'CUAA',
        'TITOLO INIZIATIVA',
        'TIPO LINEA',
        'LUOGO',
        'PROVINCIA',
        'DATA INIZIO',
        'DATA FINE'
    ];
    sheet.addRow(headers);

    // numero/anno di protocollo istanza (adatta l'ID al tuo campo HTML)
    const protocolloIstanza = ($('#protocollo_istanza').val() || '').trim();

    const dataRow = [
        protocolloIstanza, // PROT. N. DEL (A2)
        // BENEFICIARIO = Denominazione soggetto proponente
        { formula: 'INDEX(Anagrafica!B:B, MATCH("Denominazione", Anagrafica!A:A, 0))' },
        // CUAA
        { formula: 'INDEX(Anagrafica!B:B, MATCH("CUAA", Anagrafica!A:A, 0))' },
        // TITOLO INIZIATIVA
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Titolo", Iniziativa!A:A, 0))' },
        // TIPO LINEA
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Tipo linea", Iniziativa!A:A, 0))' },
        // LUOGO
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Luogo", Iniziativa!A:A, 0))' },
        // PROVINCIA
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Provincia", Iniziativa!A:A, 0))' },
        // DATA INIZIO
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Data inizio", Iniziativa!A:A, 0))' },
        // DATA FINE
        { formula: 'INDEX(Iniziativa!B:B, MATCH("Data fine", Iniziativa!A:A, 0))' }
    ];
    sheet.addRow(dataRow);

    // larghezze colonne
    sheet.columns = [
        { width: 20 }, // PROT. N. DEL
        { width: 30 }, // BENEFICIARIO
        { width: 18 }, // CUAA
        { width: 35 }, // TITOLO INIZIATIVA
        { width: 15 }, // TIPO LINEA
        { width: 20 }, // LUOGO
        { width: 10 }, // PROVINCIA
        { width: 14 }, // DATA INIZIO
        { width: 14 }  // DATA FINE
    ];

    // formati data
    sheet.getColumn(8).numFmt = 'dd/mm/yyyy';
    sheet.getColumn(9).numFmt = 'dd/mm/yyyy';

    // stile header
    const headerRow = sheet.getRow(1);
    headerRow.font = { bold: true };
    headerRow.alignment = { horizontal: 'center', vertical: 'middle' };
    headerRow.eachCell((cell) => {
        cell.fill = { type: 'pattern', pattern: 'solid', fgColor: { argb: 'BFBFBF' } };
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });

    // stile riga dati
    const row2 = sheet.getRow(2);
    row2.alignment = { vertical: 'middle', wrapText: true };
    row2.eachCell((cell) => {
        cell.border = {
            top: { style: 'thin' },
            left: { style: 'thin' },
            bottom: { style: 'thin' },
            right: { style: 'thin' }
        };
    });
}