$(document).on("click", ".conferma-riga-investimenti", function() {
    var tr = $(this).closest('tr');
    var id_riga = tr.attr("id");
    $("#"+id_riga).attr("data-errori-riga", 0);
    var oggetto_spesa      = tr.find("td:eq(0) input");
    var data_spesa         = tr.find("td:eq(1) input");
    var beneficiario_spesa = tr.find("td:eq(2) input");
    var cuaa_spesa         = tr.find("td:eq(3) input");
    var importo_spesa      = tr.find("td:eq(4) input");
    var fattura_spesa      = tr.find("td:eq(5) input");

    valida_campo(oggetto_spesa, '.errore_oggetto_spesa', regex_string, "Il valore inserito deve avere almeno due caratteri.", "Categoria della spesa obbligatoria.");
    valida_campo(data_spesa, '.errore_data_spesa', regex_data, null, "Data della spesa obbligatoria.");
    valida_campo(beneficiario_spesa, '.errore_beneficiario_spesa', regex_string, "Il valore inserito deve avere almeno due caratteri.", "Beneficiario della spesa obbligatorio.");
    valida_campo(cuaa_spesa, '.errore_cuaa_spesa', controllaCFPIVA, "Codice CUAA errato.", "Codice CUAA obbligatorio.");
    valida_campo(importo_spesa, '.errore_importo_spesa', regex_importo, "Importo non valido.", "Inserisci l'importo.");
    valida_campo(fattura_spesa, '.errore_n_fattura_spesa', regex_string, "Il valore inserito deve avere almeno due caratteri.", "Identificativo della fattura o del titolo obbligatorio.");

    var errori_riga = calcola_errori_singola_riga(id_riga, tr.children('td'));
    $("#"+id_riga).attr("data-errori-riga", errori_riga);
    if(errori_riga == 0){
        calcola_totale();
    }
});

function calcola_errori_singola_riga(id, tds){
    var errors = 0;
    var td_error = tds.find('div');
    td_error.each(function(){
        if($(this).hasClass("invalid-feedback")){
            errors++;
        }
    });
    return errors;
}
