function valida_campo(field, error_class, regex, error_regex_message, error_message) {
    var valore;
    var errore_descrizione = field.next(error_class);
    if (field.attr('type') !== 'file') {
        valore = field.val();
        if(valore == "" || valore.length == 0) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text(error_message);
            aggiungi_errore_tabella_investimenti();
        } else if (typeof regex === 'function') {
            if (regex(valore) === true) {
                field.removeClass("is-invalid");
                errore_descrizione.removeClass("invalid-feedback");
                errore_descrizione.text("");
                togli_errore_tabella_investimenti();
            } else {
                field.addClass("is-invalid");
                errore_descrizione.addClass("invalid-feedback");
                errore_descrizione.text(error_regex_message);
                aggiungi_errore_tabella_investimenti();
            }
        } else if (regex != null && !regex.test(valore)) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text(error_regex_message);
            aggiungi_errore_tabella_investimenti();
        } else {
            field.removeClass("is-invalid");
            errore_descrizione.removeClass("invalid-feedback");
            errore_descrizione.text("");
            togli_errore_tabella_investimenti();
        }
    } else {
        valore = field[0].files[0];
        var allowedExtensions = /(\.pdf)$/i;
        var maxSize = 5 * 1024 * 1024;
        if (!valore) {
            field.addClass("is-invalid");
            errore_descrizione.text(error_message);
            errore_descrizione.addClass("invalid-feedback");
        } 
        else if (!allowedExtensions.test(valore.name)) {
            field.addClass("is-invalid");
            errore_descrizione.addClass("invalid-feedback");
            errore_descrizione.text("Formato non valido. Caricare solo file .pdf.");
        } 
        else if (valore.size > maxSize) {
            field.addClass("is-invalid");
            errore_descrizione.text("Il file deve essere inferiore a 5MB.");
            errore_descrizione.addClass("invalid-feedback");
        } 
        else {
            field.removeClass("is-invalid");
            errore_descrizione.text("");
            errore_descrizione.removeClass("invalid-feedback");
        }
    }
}

function aggiungi_errore_tabella_investimenti() {
    var errori_prev = $("#count_errori_tabella_investimenti").val();
    var errori = errori_prev*1 + 1*1;
    $("#count_errori_tabella_investimenti").val(errori);
}

function togli_errore_tabella_investimenti() {
    var errori_prev = $("#count_errori_tabella_investimenti").val();
    var errori = errori_prev*1 - 1*1;
    $("#count_errori_tabella_investimenti").val(errori);
}

function crea_riga_allegati(id_per_allegati, dati) {
    console.log("as",id_per_allegati,dati);
    const tipo_beneficiario = getTipoBeneficiario();
    const $esistente = $("#allegati_investimenti tbody tr#" + id_per_allegati);

    let riga = '';
    let oggetto_spesa = dati.oggetto;

    if ($esistente.length > 0) {
        if (!('oggetto' in dati)) {
            const testo_oggetto = $esistente.find(`#oggetto_spesa_${id_per_allegati}`).text().trim();
            if (testo_oggetto) oggetto_spesa = testo_oggetto;
        }
    }

    switch (tipo_beneficiario) {
        case "comuni":
            riga =
            `
                <tr id="${id_per_allegati}">
                    <td>${oggetto_spesa ? `<p id="oggetto_spesa_${id_per_allegati}">${oggetto_spesa}</p>` : ''}</td>
                    <td>
                        <input type="file" class="form-control" name="delibera_affidamento" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_delibera_affidamento"></div>
                    </td>
                    <td>
                        <input type="file" class="form-control" name="delibera_pagamento" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_delibera_pagamento"></div>
                    </td>
                    <td>
                        <input type="file" class="form-control" name="mandato_pagamento" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_mandato_pagamento"></div>
                    </td>
                    <td>
                        <input type="file" class="form-control" name="fattura" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_fattura"></div>
                    </td>
                    <td>
                        <span>NON RICHIESTO</span>
                    </td>
                </tr>
            `;
            break;
        case "associazioni":
            riga =
            `
                <tr id="${id_per_allegati}">
                    <td>${oggetto_spesa ? `<p id="oggetto_spesa_${id_per_allegati}">${oggetto_spesa}</p>` : ''}</td>
                    <td>
                        <input type="file" class="form-control" name="fattura" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_fattura"></div>
                    </td>
                    <td>
                        <input type="file" class="form-control" name="ricevuta_bonifico_assegno" accept=".pdf, .doc, .docx, .xls, .xlsx">
                        <div class="errore_ricevuta_bonifico_assegno"></div>
                    </td>
                    <td>
                        <span>NON RICHIESTO</span>
                    </td>
                </tr>
            `;
            break;
    }

    $esistente.length > 0
        ? $esistente.replaceWith(riga)
        : $("#allegati_investimenti tbody").append(riga);
}


function rimuovi_riga_allegati(id_per_allegati){
    $("#allegati_investimenti tbody tr#"+id_per_allegati).remove();
}