/* validation/validazione_sezione_allegati.js
   Valida la SEZIONE ALLEGATI:
   - al click su .crea-files: header rosso/verde + badge e campi file is-invalid/is-valid
   - ignora input file nascosti o disabilitati (es. blocchi non pertinenti)
*/
(function () {
  'use strict';

  // --- util: colora header + badge (solo classi Bootstrap) ---
  // --- util: colora header + badge (uniforme come Anagrafica) ---
  function paintHeader(sectionSelector, badgeSpanId, errorCount) {
    const headerBtn = document.querySelector(`${sectionSelector} .accordion-button`);
    const badgeSpan = document.getElementById(badgeSpanId);
    if (!headerBtn || !badgeSpan) return;

    // reset classi
    headerBtn.classList.remove(
      'bg-danger', 'bg-success', 'text-white',
      'background-color-success-accordion', 'background-color-error-accordion'
    );
    badgeSpan.classList.remove('badge', 'text-bg-success', 'text-bg-error');
    badgeSpan.classList.add('badge');

    if (errorCount > 0) {
      headerBtn.classList.add('background-color-error-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-error');
      badgeSpan.textContent = `Vi ${errorCount === 1 ? 'è' : 'sono'} ${errorCount} ${errorCount === 1 ? 'errore' : 'errori'}`;
    } else {
      headerBtn.classList.add('background-color-success-accordion', 'text-white');
      badgeSpan.classList.add('text-bg-success');
      badgeSpan.textContent = 'Sezione Compilata Correttamente';
    }
  }

  function markOk(el, errBox) {
    el.classList.remove('is-invalid');
    el.classList.add('is-valid');
    if (errBox) errBox.textContent = '';
  }
  function markErr(el, errBox, msg) {
    el.classList.add('is-invalid');
    el.classList.remove('is-valid');
    if (errBox) errBox.innerHTML = `<small class="text-danger">${msg}</small>`;
  }

  function validaSezioneAllegati() {
    const section = document.getElementById('allegati_impegno');
    if (!section) return true;

    let errorCount = 0;

    // Contenitore opzionale (solo per enti non pubblici)
    const optionalBlock = document.getElementById('allegati_impegno_enti_non_pubblici');
    const optionalHidden = optionalBlock
      ? (getComputedStyle(optionalBlock).display === 'none' || optionalBlock.classList.contains('d-none'))
      : false;

    // Prende TUTTI i file required nella sezione (anche se l'accordion è chiuso)
    const files = section.querySelectorAll('input[type="file"][required]');

    files.forEach(inp => {
      // Se è nel blocco "enti non pubblici" e quel blocco è nascosto → salta
      const isInOptional = optionalBlock && optionalBlock.contains(inp);
      if ((isInOptional && optionalHidden) || inp.disabled) {
        // pulizia eventuali classi/errore
        inp.classList.remove('is-invalid');
        inp.classList.remove('is-valid');
        const err = document.getElementById('errore_' + inp.id);
        if (err) err.textContent = '';
        return;
      }

      const err = document.getElementById('errore_' + inp.id);
      const hasFile = !!(inp.files && inp.files.length);

      if (!hasFile) {
        errorCount++;
        inp.classList.add('is-invalid');
        inp.classList.remove('is-valid');
        if (err) err.innerHTML = '<small class="text-danger">Allegato obbligatorio.</small>';
      } else {
        inp.classList.remove('is-invalid');
        inp.classList.add('is-valid');
        if (err) err.textContent = '';
      }
    });

    // Header + badge (solo Bootstrap)
    paintHeader('#allegati_impegno', 'validazione_sezione_allegati_impegno', errorCount);
    return errorCount === 0;
  }

  // --- init: attacca al click su "Crea Files" ---
  function initValidazioneAllegati() {
    const badge = document.getElementById('validazione_sezione_allegati_impegno');
    if (badge) badge.innerHTML = ''; // nessun badge all’avvio

    document.querySelectorAll('.crea-files').forEach(btn => {
      btn.addEventListener('click', (e) => {
        const ok = validaSezioneAllegati();
        if (!ok) {
          e.preventDefault();
          // apri e scrolla la sezione
          const collapse = document.getElementById('collapseFour');
          if (collapse && !collapse.classList.contains('show') && window.bootstrap?.Collapse) {
            new bootstrap.Collapse(collapse, { toggle: true });
          }
          document.getElementById('allegati_impegno')?.scrollIntoView({ behavior: 'smooth', block: 'start' });
        }
      });
    });
  }

  // esponi le funzioni se servono altrove
  window.ValidationAllegati = {
    validate: validaSezioneAllegati,
    init: initValidazioneAllegati
  };

  // auto-init quando il DOM è pronto
  document.addEventListener('DOMContentLoaded', initValidazioneAllegati);
})();





