// ===== MAPPATURA BENEFICIARIO → LINEE CONSENTITE =====
const LINEE_PER_BENEF = {
  a: ["A", "B"],   // a–e: A e B
  b: ["A", "B"],
  c: ["A", "B"],
  d: ["A", "B"],
  e: ["A", "B"],
  f: ["A"],        // f: solo A
  g: ["A"]         // g: solo A
};

// ===== MAPPATURA IMPORTI MASSIMI =====
const IMPORTI_MAX = {
  a: { A: 15000, B: 50000 },
  b: { A: 15000, B: 50000 },
  c: { A: 15000, B: 50000 },
  d: { A: 15000, B: 50000 },
  e: { A: 15000, B: 50000 },
  f: { A: 15000 }, // solo A
  g: { A: 10000 }  // solo A, 10.000 €
};

function riempi_contributo_richiesto(linea) {
  const $input = $("#contributo_ammesso");
  const ben = $('input[name=tipo_beneficiario]:checked').val(); // a..g

  // se manca beneficiario o linea: svuota
  if (!ben || !linea) {
      $input.val("");
      return;
  }

  const importiLinea = IMPORTI_MAX[ben] || {};
  const max = importiLinea[linea];

  // se esiste un importo per quella coppia beneficiario/linea → lo imposto
  if (max) {
      $input.val(max);
  } else {
      // combinazione non prevista (es. linea B per f o g) → svuoto
      $input.val("");
  }
}
function valida_linea(linea, suffisso) {
  const input = $(`#nome${suffisso}`);
  const errore = $(`#errore_nome${suffisso}`);

  if (linea.length === 0) {
    input.addClass("is-invalid");
    errore.addClass("invalid-feedback").text("Linea obbligatoria.");
  } else {
    input.removeClass("is-invalid");
    errore.removeClass("invalid-feedback").text("");
  }
}

function valida_contributo(contributo, suffisso) {
}

$(document).on("change", "#selezione_tipo_linea", function () {
    const linea = $(this).val();
    riempi_contributo_richiesto(linea);
});





// Se non esiste già, piccola util per colorare header + badge
if (typeof paintHeader !== 'function') {
  function paintHeader(sectionSelector, badgeSpanId, errorCount) {
    const headerBtn = document.querySelector(`${sectionSelector} .accordion-button`);
    const badgeSpan = document.getElementById(badgeSpanId);
    if (!headerBtn || !badgeSpan) return;
    headerBtn.classList.remove('bg-danger','bg-success','text-white');
    if (errorCount > 0) {
      headerBtn.classList.add('bg-danger','text-white');
      badgeSpan.innerHTML = `<span class="badge bg-danger ms-2">Vi sono ${errorCount} errori</span>`;
    } else {
      headerBtn.classList.add('bg-success','text-white');
      badgeSpan.innerHTML = `<span class="badge bg-success ms-2">Sezione Compilata Correttamente</span>`;
    }
  }
}
// helper per i campi
function markOk(el, errBox){ el.classList.remove('is-invalid'); el.classList.add('is-valid'); if(errBox) errBox.textContent=''; }
function markErr(el, errBox, msg){ el.classList.add('is-invalid'); el.classList.remove('is-valid'); if(errBox) errBox.innerHTML=`<small class="text-danger">${msg}</small>`; }

// ---- VALIDAZIONE SEZIONE RICHIESTA CONTRIBUTO ----
function validaSezioneContributo() {
  let errorCount = 0;

  // Tipo linea
  (function(){
    const sel = document.getElementById('selezione_tipo_linea');
    const err = document.getElementById('errore_tipo_linea');
    const v = (sel?.value || '').trim();
    if (!v) { errorCount++; markErr(sel, err, 'Tipo linea obbligatorio.'); }
    else { markOk(sel, err); }
  })();

  // Contributo richiesto (numero > 0; accetta 1.234,56 o 1234.56 ecc.)
  (function(){
    const inp = document.getElementById('contributo_ammesso');
    const err = document.getElementById('errore_contributo_ammesso');
    const raw = (inp?.value || '').trim().replace(/€/g,'').replace(/\s/g,'');
    const normalized = raw.replace(/\./g,'').replace(',', '.'); // rimuove separatori migliaia, usa . come decimale
    const num = parseFloat(normalized);

    if (!raw) {
      errorCount++; markErr(inp, err, 'Contributo obbligatorio.');
    } else if (isNaN(num) || num <= 0) {
      errorCount++; markErr(inp, err, 'Inserisci un importo valido.');
    } else {
      markOk(inp, err);
    }
  })();

  // Aggiorna header e badge
  paintHeader('#contributo','validazione_sezione_contributo', errorCount);
  return errorCount === 0;
}

// ---- CLICK su "Crea Files": valida solo questa sezione, apri e scrolla se KO ----
document.addEventListener('DOMContentLoaded', () => {
  const bContr = document.getElementById('validazione_sezione_contributo');
  if (bContr) bContr.innerHTML = ''; // nessun badge all'avvio

  document.querySelectorAll('.crea-files').forEach(btn => {
    btn.addEventListener('click', (e) => {
      const ok = validaSezioneContributo();
      if (!ok) {
        e.preventDefault();
        const collapse = document.getElementById('collapseThree');
        if (collapse && !collapse.classList.contains('show') && window.bootstrap?.Collapse) {
          new bootstrap.Collapse(collapse, { toggle: true });
        }
        document.getElementById('contributo')?.scrollIntoView({ behavior: 'smooth', block: 'start' });
      }
    });
  });
});


// Quando cambio beneficiario: abilito/disabilito le linee corrette e svuoto contributo
$(document).on("change", "input[name=tipo_beneficiario]", function () {
  const ben = $(this).val();              // a..g
  const linee = LINEE_PER_BENEF[ben] || [];
  const $sel = $("#selezione_tipo_linea");

  // reset select linea
  $sel.val("");

  // abilita/disabilita opzioni
  $sel.find("option").each(function () {
      const val = $(this).val();
      if (!val) return; // lascia "Seleziona il tipo di linea"
      $(this).prop("disabled", linee.indexOf(val) === -1);
  });

  // svuota contributo
  $("#contributo_ammesso").val("");
});